<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryHostingMailList StructType
 * @subpackage Structs
 */
class StructQueryHostingMailList extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The mail
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $mail;
    /**
     * Constructor method for StructQueryHostingMailList
     * @uses StructQueryHostingMailList::setDomain()
     * @uses StructQueryHostingMailList::setMail()
     * @param string $domain
     * @param string[] $mail
     */
    public function __construct($domain = null, array $mail = array())
    {
        $this
            ->setDomain($domain)
            ->setMail($mail);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \netim\StructType\StructQueryHostingMailList
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get mail value
     * @return string[]|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @throws \InvalidArgumentException
     * @param string[] $mail
     * @return \netim\StructType\StructQueryHostingMailList
     */
    public function setMail(array $mail = array())
    {
        foreach ($mail as $structQueryHostingMailListMailItem) {
            // validation for constraint: itemType
            if (!is_string($structQueryHostingMailListMailItem)) {
                throw new \InvalidArgumentException(sprintf('The mail property can only contain items of string, "%s" given', is_object($structQueryHostingMailListMailItem) ? get_class($structQueryHostingMailListMailItem) : gettype($structQueryHostingMailListMailItem)), __LINE__);
            }
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Add item to mail value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructQueryHostingMailList
     */
    public function addToMail($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The mail property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructQueryHostingMailList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
