<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryHostingMailFwdList StructType
 * @subpackage Structs
 */
class StructQueryHostingMailFwdList extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The mailFwd
     * Meta informations extracted from the WSDL
     * - arrayType: typens:StructMailFwd[]
     * - ref: soapenc:arrayType
     * @var \netim\StructType\StructMailFwd[]
     */
    public $mailFwd;
    /**
     * Constructor method for StructQueryHostingMailFwdList
     * @uses StructQueryHostingMailFwdList::setDomain()
     * @uses StructQueryHostingMailFwdList::setMailFwd()
     * @param string $domain
     * @param \netim\StructType\StructMailFwd[] $mailFwd
     */
    public function __construct($domain = null, array $mailFwd = array())
    {
        $this
            ->setDomain($domain)
            ->setMailFwd($mailFwd);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \netim\StructType\StructQueryHostingMailFwdList
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get mailFwd value
     * @return \netim\StructType\StructMailFwd[]|null
     */
    public function getMailFwd()
    {
        return $this->mailFwd;
    }
    /**
     * Set mailFwd value
     * @throws \InvalidArgumentException
     * @param \netim\StructType\StructMailFwd[] $mailFwd
     * @return \netim\StructType\StructQueryHostingMailFwdList
     */
    public function setMailFwd(array $mailFwd = array())
    {
        foreach ($mailFwd as $structQueryHostingMailFwdListMailFwdItem) {
            // validation for constraint: itemType
            if (!$structQueryHostingMailFwdListMailFwdItem instanceof \netim\StructType\StructMailFwd) {
                throw new \InvalidArgumentException(sprintf('The mailFwd property can only contain items of \netim\StructType\StructMailFwd, "%s" given', is_object($structQueryHostingMailFwdListMailFwdItem) ? get_class($structQueryHostingMailFwdListMailFwdItem) : gettype($structQueryHostingMailFwdListMailFwdItem)), __LINE__);
            }
        }
        $this->mailFwd = $mailFwd;
        return $this;
    }
    /**
     * Add item to mailFwd value
     * @throws \InvalidArgumentException
     * @param \netim\StructType\StructMailFwd $item
     * @return \netim\StructType\StructQueryHostingMailFwdList
     */
    public function addToMailFwd(\netim\StructType\StructMailFwd $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \netim\StructType\StructMailFwd) {
            throw new \InvalidArgumentException(sprintf('The mailFwd property can only contain items of \netim\StructType\StructMailFwd, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mailFwd[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructQueryHostingMailFwdList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
