<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryHostingMailAliasList StructType
 * @subpackage Structs
 */
class StructQueryHostingMailAliasList extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The mailAlias
     * Meta informations extracted from the WSDL
     * - arrayType: typens:StructMailAlias[]
     * - ref: soapenc:arrayType
     * @var \netim\StructType\StructMailAlias[]
     */
    public $mailAlias;
    /**
     * Constructor method for StructQueryHostingMailAliasList
     * @uses StructQueryHostingMailAliasList::setDomain()
     * @uses StructQueryHostingMailAliasList::setMailAlias()
     * @param string $domain
     * @param \netim\StructType\StructMailAlias[] $mailAlias
     */
    public function __construct($domain = null, array $mailAlias = array())
    {
        $this
            ->setDomain($domain)
            ->setMailAlias($mailAlias);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \netim\StructType\StructQueryHostingMailAliasList
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get mailAlias value
     * @return \netim\StructType\StructMailAlias[]|null
     */
    public function getMailAlias()
    {
        return $this->mailAlias;
    }
    /**
     * Set mailAlias value
     * @throws \InvalidArgumentException
     * @param \netim\StructType\StructMailAlias[] $mailAlias
     * @return \netim\StructType\StructQueryHostingMailAliasList
     */
    public function setMailAlias(array $mailAlias = array())
    {
        foreach ($mailAlias as $structQueryHostingMailAliasListMailAliasItem) {
            // validation for constraint: itemType
            if (!$structQueryHostingMailAliasListMailAliasItem instanceof \netim\StructType\StructMailAlias) {
                throw new \InvalidArgumentException(sprintf('The mailAlias property can only contain items of \netim\StructType\StructMailAlias, "%s" given', is_object($structQueryHostingMailAliasListMailAliasItem) ? get_class($structQueryHostingMailAliasListMailAliasItem) : gettype($structQueryHostingMailAliasListMailAliasItem)), __LINE__);
            }
        }
        $this->mailAlias = $mailAlias;
        return $this;
    }
    /**
     * Add item to mailAlias value
     * @throws \InvalidArgumentException
     * @param \netim\StructType\StructMailAlias $item
     * @return \netim\StructType\StructQueryHostingMailAliasList
     */
    public function addToMailAlias(\netim\StructType\StructMailAlias $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \netim\StructType\StructMailAlias) {
            throw new \InvalidArgumentException(sprintf('The mailAlias property can only contain items of \netim\StructType\StructMailAlias, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mailAlias[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructQueryHostingMailAliasList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
