<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructMailFwd StructType
 * @subpackage Structs
 */
class StructMailFwd extends AbstractStructBase
{
    /**
     * The mail
     * @var string
     */
    public $mail;
    /**
     * The forward
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $forward;
    /**
     * Constructor method for StructMailFwd
     * @uses StructMailFwd::setMail()
     * @uses StructMailFwd::setForward()
     * @param string $mail
     * @param string[] $forward
     */
    public function __construct($mail = null, array $forward = array())
    {
        $this
            ->setMail($mail)
            ->setForward($forward);
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \netim\StructType\StructMailFwd
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get forward value
     * @return string[]|null
     */
    public function getForward()
    {
        return $this->forward;
    }
    /**
     * Set forward value
     * @throws \InvalidArgumentException
     * @param string[] $forward
     * @return \netim\StructType\StructMailFwd
     */
    public function setForward(array $forward = array())
    {
        foreach ($forward as $structMailFwdForwardItem) {
            // validation for constraint: itemType
            if (!is_string($structMailFwdForwardItem)) {
                throw new \InvalidArgumentException(sprintf('The forward property can only contain items of string, "%s" given', is_object($structMailFwdForwardItem) ? get_class($structMailFwdForwardItem) : gettype($structMailFwdForwardItem)), __LINE__);
            }
        }
        $this->forward = $forward;
        return $this;
    }
    /**
     * Add item to forward value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructMailFwd
     */
    public function addToForward($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The forward property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->forward[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructMailFwd
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
