<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructMailAlias StructType
 * @subpackage Structs
 */
class StructMailAlias extends AbstractStructBase
{
    /**
     * The mail
     * @var string
     */
    public $mail;
    /**
     * The alias
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $alias;
    /**
     * Constructor method for StructMailAlias
     * @uses StructMailAlias::setMail()
     * @uses StructMailAlias::setAlias()
     * @param string $mail
     * @param string[] $alias
     */
    public function __construct($mail = null, array $alias = array())
    {
        $this
            ->setMail($mail)
            ->setAlias($alias);
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \netim\StructType\StructMailAlias
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get alias value
     * @return string[]|null
     */
    public function getAlias()
    {
        return $this->alias;
    }
    /**
     * Set alias value
     * @throws \InvalidArgumentException
     * @param string[] $alias
     * @return \netim\StructType\StructMailAlias
     */
    public function setAlias(array $alias = array())
    {
        foreach ($alias as $structMailAliasAliasItem) {
            // validation for constraint: itemType
            if (!is_string($structMailAliasAliasItem)) {
                throw new \InvalidArgumentException(sprintf('The alias property can only contain items of string, "%s" given', is_object($structMailAliasAliasItem) ? get_class($structMailAliasAliasItem) : gettype($structMailAliasAliasItem)), __LINE__);
            }
        }
        $this->alias = $alias;
        return $this;
    }
    /**
     * Add item to alias value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructMailAlias
     */
    public function addToAlias($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The alias property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->alias[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructMailAlias
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
