<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructDomainInfo StructType
 * @subpackage Structs
 */
class StructDomainInfo extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The dateCreate
     * @var string
     */
    public $dateCreate;
    /**
     * The dateExpiration
     * @var string
     */
    public $dateExpiration;
    /**
     * The dateMinRenew
     * @var string
     */
    public $dateMinRenew;
    /**
     * The dateMaxRenew
     * @var string
     */
    public $dateMaxRenew;
    /**
     * The dateMaxRestore
     * @var string
     */
    public $dateMaxRestore;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The idOwner
     * @var string
     */
    public $idOwner;
    /**
     * The idAdmin
     * @var string
     */
    public $idAdmin;
    /**
     * The idTech
     * @var string
     */
    public $idTech;
    /**
     * The idBilling
     * @var string
     */
    public $idBilling;
    /**
     * The domainIsLock
     * @var int
     */
    public $domainIsLock;
    /**
     * The maskedWhois
     * @var int
     */
    public $maskedWhois;
    /**
     * The autoRenew
     * @var int
     */
    public $autoRenew;
    /**
     * The ns
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $ns;
    /**
     * The IsSigned
     * @var int
     */
    public $IsSigned;
    /**
     * The authID
     * @var string
     */
    public $authID;
    /**
     * Constructor method for StructDomainInfo
     * @uses StructDomainInfo::setDomain()
     * @uses StructDomainInfo::setDateCreate()
     * @uses StructDomainInfo::setDateExpiration()
     * @uses StructDomainInfo::setDateMinRenew()
     * @uses StructDomainInfo::setDateMaxRenew()
     * @uses StructDomainInfo::setDateMaxRestore()
     * @uses StructDomainInfo::setStatus()
     * @uses StructDomainInfo::setIdOwner()
     * @uses StructDomainInfo::setIdAdmin()
     * @uses StructDomainInfo::setIdTech()
     * @uses StructDomainInfo::setIdBilling()
     * @uses StructDomainInfo::setDomainIsLock()
     * @uses StructDomainInfo::setMaskedWhois()
     * @uses StructDomainInfo::setAutoRenew()
     * @uses StructDomainInfo::setNs()
     * @uses StructDomainInfo::setIsSigned()
     * @uses StructDomainInfo::setAuthID()
     * @param string $domain
     * @param string $dateCreate
     * @param string $dateExpiration
     * @param string $dateMinRenew
     * @param string $dateMaxRenew
     * @param string $dateMaxRestore
     * @param string $status
     * @param string $idOwner
     * @param string $idAdmin
     * @param string $idTech
     * @param string $idBilling
     * @param int $domainIsLock
     * @param int $maskedWhois
     * @param int $autoRenew
     * @param string[] $ns
     * @param int $isSigned
     * @param string $authID
     */
    public function __construct($domain = null, $dateCreate = null, $dateExpiration = null, $dateMinRenew = null, $dateMaxRenew = null, $dateMaxRestore = null, $status = null, $idOwner = null, $idAdmin = null, $idTech = null, $idBilling = null, $domainIsLock = null, $maskedWhois = null, $autoRenew = null, array $ns = array(), $isSigned = null, $authID = null)
    {
        $this
            ->setDomain($domain)
            ->setDateCreate($dateCreate)
            ->setDateExpiration($dateExpiration)
            ->setDateMinRenew($dateMinRenew)
            ->setDateMaxRenew($dateMaxRenew)
            ->setDateMaxRestore($dateMaxRestore)
            ->setStatus($status)
            ->setIdOwner($idOwner)
            ->setIdAdmin($idAdmin)
            ->setIdTech($idTech)
            ->setIdBilling($idBilling)
            ->setDomainIsLock($domainIsLock)
            ->setMaskedWhois($maskedWhois)
            ->setAutoRenew($autoRenew)
            ->setNs($ns)
            ->setIsSigned($isSigned)
            ->setAuthID($authID);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \netim\StructType\StructDomainInfo
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get dateCreate value
     * @return string|null
     */
    public function getDateCreate()
    {
        return $this->dateCreate;
    }
    /**
     * Set dateCreate value
     * @param string $dateCreate
     * @return \netim\StructType\StructDomainInfo
     */
    public function setDateCreate($dateCreate = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreate) && !is_string($dateCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCreate)), __LINE__);
        }
        $this->dateCreate = $dateCreate;
        return $this;
    }
    /**
     * Get dateExpiration value
     * @return string|null
     */
    public function getDateExpiration()
    {
        return $this->dateExpiration;
    }
    /**
     * Set dateExpiration value
     * @param string $dateExpiration
     * @return \netim\StructType\StructDomainInfo
     */
    public function setDateExpiration($dateExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($dateExpiration) && !is_string($dateExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateExpiration)), __LINE__);
        }
        $this->dateExpiration = $dateExpiration;
        return $this;
    }
    /**
     * Get dateMinRenew value
     * @return string|null
     */
    public function getDateMinRenew()
    {
        return $this->dateMinRenew;
    }
    /**
     * Set dateMinRenew value
     * @param string $dateMinRenew
     * @return \netim\StructType\StructDomainInfo
     */
    public function setDateMinRenew($dateMinRenew = null)
    {
        // validation for constraint: string
        if (!is_null($dateMinRenew) && !is_string($dateMinRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateMinRenew)), __LINE__);
        }
        $this->dateMinRenew = $dateMinRenew;
        return $this;
    }
    /**
     * Get dateMaxRenew value
     * @return string|null
     */
    public function getDateMaxRenew()
    {
        return $this->dateMaxRenew;
    }
    /**
     * Set dateMaxRenew value
     * @param string $dateMaxRenew
     * @return \netim\StructType\StructDomainInfo
     */
    public function setDateMaxRenew($dateMaxRenew = null)
    {
        // validation for constraint: string
        if (!is_null($dateMaxRenew) && !is_string($dateMaxRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateMaxRenew)), __LINE__);
        }
        $this->dateMaxRenew = $dateMaxRenew;
        return $this;
    }
    /**
     * Get dateMaxRestore value
     * @return string|null
     */
    public function getDateMaxRestore()
    {
        return $this->dateMaxRestore;
    }
    /**
     * Set dateMaxRestore value
     * @param string $dateMaxRestore
     * @return \netim\StructType\StructDomainInfo
     */
    public function setDateMaxRestore($dateMaxRestore = null)
    {
        // validation for constraint: string
        if (!is_null($dateMaxRestore) && !is_string($dateMaxRestore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateMaxRestore)), __LINE__);
        }
        $this->dateMaxRestore = $dateMaxRestore;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \netim\StructType\StructDomainInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get idOwner value
     * @return string|null
     */
    public function getIdOwner()
    {
        return $this->idOwner;
    }
    /**
     * Set idOwner value
     * @param string $idOwner
     * @return \netim\StructType\StructDomainInfo
     */
    public function setIdOwner($idOwner = null)
    {
        // validation for constraint: string
        if (!is_null($idOwner) && !is_string($idOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idOwner)), __LINE__);
        }
        $this->idOwner = $idOwner;
        return $this;
    }
    /**
     * Get idAdmin value
     * @return string|null
     */
    public function getIdAdmin()
    {
        return $this->idAdmin;
    }
    /**
     * Set idAdmin value
     * @param string $idAdmin
     * @return \netim\StructType\StructDomainInfo
     */
    public function setIdAdmin($idAdmin = null)
    {
        // validation for constraint: string
        if (!is_null($idAdmin) && !is_string($idAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idAdmin)), __LINE__);
        }
        $this->idAdmin = $idAdmin;
        return $this;
    }
    /**
     * Get idTech value
     * @return string|null
     */
    public function getIdTech()
    {
        return $this->idTech;
    }
    /**
     * Set idTech value
     * @param string $idTech
     * @return \netim\StructType\StructDomainInfo
     */
    public function setIdTech($idTech = null)
    {
        // validation for constraint: string
        if (!is_null($idTech) && !is_string($idTech)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idTech)), __LINE__);
        }
        $this->idTech = $idTech;
        return $this;
    }
    /**
     * Get idBilling value
     * @return string|null
     */
    public function getIdBilling()
    {
        return $this->idBilling;
    }
    /**
     * Set idBilling value
     * @param string $idBilling
     * @return \netim\StructType\StructDomainInfo
     */
    public function setIdBilling($idBilling = null)
    {
        // validation for constraint: string
        if (!is_null($idBilling) && !is_string($idBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idBilling)), __LINE__);
        }
        $this->idBilling = $idBilling;
        return $this;
    }
    /**
     * Get domainIsLock value
     * @return int|null
     */
    public function getDomainIsLock()
    {
        return $this->domainIsLock;
    }
    /**
     * Set domainIsLock value
     * @param int $domainIsLock
     * @return \netim\StructType\StructDomainInfo
     */
    public function setDomainIsLock($domainIsLock = null)
    {
        // validation for constraint: int
        if (!is_null($domainIsLock) && !is_numeric($domainIsLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($domainIsLock)), __LINE__);
        }
        $this->domainIsLock = $domainIsLock;
        return $this;
    }
    /**
     * Get maskedWhois value
     * @return int|null
     */
    public function getMaskedWhois()
    {
        return $this->maskedWhois;
    }
    /**
     * Set maskedWhois value
     * @param int $maskedWhois
     * @return \netim\StructType\StructDomainInfo
     */
    public function setMaskedWhois($maskedWhois = null)
    {
        // validation for constraint: int
        if (!is_null($maskedWhois) && !is_numeric($maskedWhois)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maskedWhois)), __LINE__);
        }
        $this->maskedWhois = $maskedWhois;
        return $this;
    }
    /**
     * Get autoRenew value
     * @return int|null
     */
    public function getAutoRenew()
    {
        return $this->autoRenew;
    }
    /**
     * Set autoRenew value
     * @param int $autoRenew
     * @return \netim\StructType\StructDomainInfo
     */
    public function setAutoRenew($autoRenew = null)
    {
        // validation for constraint: int
        if (!is_null($autoRenew) && !is_numeric($autoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoRenew)), __LINE__);
        }
        $this->autoRenew = $autoRenew;
        return $this;
    }
    /**
     * Get ns value
     * @return string[]|null
     */
    public function getNs()
    {
        return $this->ns;
    }
    /**
     * Set ns value
     * @throws \InvalidArgumentException
     * @param string[] $ns
     * @return \netim\StructType\StructDomainInfo
     */
    public function setNs(array $ns = array())
    {
        foreach ($ns as $structDomainInfoNsItem) {
            // validation for constraint: itemType
            if (!is_string($structDomainInfoNsItem)) {
                throw new \InvalidArgumentException(sprintf('The ns property can only contain items of string, "%s" given', is_object($structDomainInfoNsItem) ? get_class($structDomainInfoNsItem) : gettype($structDomainInfoNsItem)), __LINE__);
            }
        }
        $this->ns = $ns;
        return $this;
    }
    /**
     * Add item to ns value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructDomainInfo
     */
    public function addToNs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ns property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ns[] = $item;
        return $this;
    }
    /**
     * Get IsSigned value
     * @return int|null
     */
    public function getIsSigned()
    {
        return $this->IsSigned;
    }
    /**
     * Set IsSigned value
     * @param int $isSigned
     * @return \netim\StructType\StructDomainInfo
     */
    public function setIsSigned($isSigned = null)
    {
        // validation for constraint: int
        if (!is_null($isSigned) && !is_numeric($isSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isSigned)), __LINE__);
        }
        $this->IsSigned = $isSigned;
        return $this;
    }
    /**
     * Get authID value
     * @return string|null
     */
    public function getAuthID()
    {
        return $this->authID;
    }
    /**
     * Set authID value
     * @param string $authID
     * @return \netim\StructType\StructDomainInfo
     */
    public function setAuthID($authID = null)
    {
        // validation for constraint: string
        if (!is_null($authID) && !is_string($authID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authID)), __LINE__);
        }
        $this->authID = $authID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructDomainInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
