<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructDSRecord StructType
 * @subpackage Structs
 */
class StructDSRecord extends AbstractStructBase
{
    /**
     * The key
     * @var int
     */
    public $key;
    /**
     * The type
     * @var int
     */
    public $type;
    /**
     * The digest
     * @var string
     */
    public $digest;
    /**
     * Constructor method for StructDSRecord
     * @uses StructDSRecord::setKey()
     * @uses StructDSRecord::setType()
     * @uses StructDSRecord::setDigest()
     * @param int $key
     * @param int $type
     * @param string $digest
     */
    public function __construct($key = null, $type = null, $digest = null)
    {
        $this
            ->setKey($key)
            ->setType($type)
            ->setDigest($digest);
    }
    /**
     * Get key value
     * @return int|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param int $key
     * @return \netim\StructType\StructDSRecord
     */
    public function setKey($key = null)
    {
        // validation for constraint: int
        if (!is_null($key) && !is_numeric($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \netim\StructType\StructDSRecord
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->digest;
    }
    /**
     * Set digest value
     * @param string $digest
     * @return \netim\StructType\StructDSRecord
     */
    public function setDigest($digest = null)
    {
        // validation for constraint: string
        if (!is_null($digest) && !is_string($digest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digest)), __LINE__);
        }
        $this->digest = $digest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructDSRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
