<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Website ServiceType
 * @subpackage Services
 */
class Website extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named websiteCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fqdn
     * @param string $prod
     * @param string $duration
     * @return int|bool
     */
    public function websiteCreate($iDSession, $fqdn, $prod, $duration)
    {
        try {
            $this->setResult(self::getSoapClient()->websiteCreate($iDSession, $fqdn, $prod, $duration));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named websiteRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fqdn
     * @param string $prod
     * @param string $duration
     * @return int|bool
     */
    public function websiteRenew($iDSession, $fqdn, $prod, $duration)
    {
        try {
            $this->setResult(self::getSoapClient()->websiteRenew($iDSession, $fqdn, $prod, $duration));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named websiteGetControlPanelURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fqdn
     * @return string|bool
     */
    public function websiteGetControlPanelURL($iDSession, $fqdn)
    {
        try {
            $this->setResult(self::getSoapClient()->websiteGetControlPanelURL($iDSession, $fqdn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named websiteSetPreference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fqdn
     * @param string $code
     * @param string $value
     * @return int|bool
     */
    public function websiteSetPreference($iDSession, $fqdn, $code, $value)
    {
        try {
            $this->setResult(self::getSoapClient()->websiteSetPreference($iDSession, $fqdn, $code, $value));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named websiteDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $fqdn
     * @return int|bool
     */
    public function websiteDelete($iDSession, $fqdn)
    {
        try {
            $this->setResult(self::getSoapClient()->websiteDelete($iDSession, $fqdn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
