<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hosting ServiceType
 * @subpackage Services
 */
class Hosting extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hostingSetPreference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $code
     * @param string $value
     * @param string $additional
     * @return int|bool
     */
    public function hostingSetPreference($iDSession, $domain, $code, $value, $additional)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingSetPreference($iDSession, $domain, $code, $value, $additional));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $prod
     * @param string $duration
     * @param string $lang
     * @return int|bool
     */
    public function hostingCreate($iDSession, $domain, $prod, $duration, $lang)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingCreate($iDSession, $domain, $prod, $duration, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $typeDelete
     * @return int|bool
     */
    public function hostingDelete($iDSession, $domain, $typeDelete)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingDelete($iDSession, $domain, $typeDelete));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $duration
     * @return int|bool
     */
    public function hostingRenew($iDSession, $domain, $duration)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingRenew($iDSession, $domain, $duration));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingUpgrade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $prod
     * @return int|bool
     */
    public function hostingUpgrade($iDSession, $domain, $prod)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingUpgrade($iDSession, $domain, $prod));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructHostingInfo|bool
     */
    public function hostingInfo($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingInfo($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @param string $password
     * @param string $realname
     * @param string $quota
     * @param string $cc
     * @return int|bool
     */
    public function hostingMailCreate($iDSession, $mail, $password, $realname, $quota, $cc)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailCreate($iDSession, $mail, $password, $realname, $quota, $cc));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @return int|bool
     */
    public function hostingMailDelete($iDSession, $mail)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailDelete($iDSession, $mail));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailSetPreference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @param string $code
     * @param string $value
     * @return int|bool
     */
    public function hostingMailSetPreference($iDSession, $mail, $code, $value)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailSetPreference($iDSession, $mail, $code, $value));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @return \netim\StructType\StructHostingMailInfo|bool
     */
    public function hostingMailInfo($iDSession, $mail)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailInfo($iDSession, $mail));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailDomainAliasCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $domainAlias
     * @return int|bool
     */
    public function hostingMailDomainAliasCreate($iDSession, $domain, $domainAlias)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailDomainAliasCreate($iDSession, $domain, $domainAlias));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailDomainAliasDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $domainAlias
     * @return int|bool
     */
    public function hostingMailDomainAliasDelete($iDSession, $domain, $domainAlias)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailDomainAliasDelete($iDSession, $domain, $domainAlias));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailDomainAliasesInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructHostingMailDomainAliasesInfo|bool
     */
    public function hostingMailDomainAliasesInfo($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailDomainAliasesInfo($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailAliasCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @param string $mailAlias
     * @return int|bool
     */
    public function hostingMailAliasCreate($iDSession, $mail, $mailAlias)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailAliasCreate($iDSession, $mail, $mailAlias));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailAliasDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @param string $mailAlias
     * @return int|bool
     */
    public function hostingMailAliasDelete($iDSession, $mail, $mailAlias)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailAliasDelete($iDSession, $mail, $mailAlias));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailAliasesInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @param string $mailAlias
     * @return \netim\StructType\StructHostingMailAliasesInfo|bool
     */
    public function hostingMailAliasesInfo($iDSession, $mail, $mailAlias)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailAliasesInfo($iDSession, $mail, $mailAlias));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailFwdCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @param string $mailForward
     * @return int|bool
     */
    public function hostingMailFwdCreate($iDSession, $mail, $mailForward)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailFwdCreate($iDSession, $mail, $mailForward));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailFwdDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @param string $mailForward
     * @return int|bool
     */
    public function hostingMailFwdDelete($iDSession, $mail, $mailForward)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailFwdDelete($iDSession, $mail, $mailForward));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailFwdInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $mail
     * @return \netim\StructType\StructHostingMailFwdInfo|bool
     */
    public function hostingMailFwdInfo($iDSession, $mail)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailFwdInfo($iDSession, $mail));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailCatchallCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @param string $mail
     * @return int|bool
     */
    public function hostingMailCatchallCreate($iDSession, $domain, $mail)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailCatchallCreate($iDSession, $domain, $mail));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailCatchallDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return int|bool
     */
    public function hostingMailCatchallDelete($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailCatchallDelete($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostingMailCatchallInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $domain
     * @return \netim\StructType\StructHostingMailCatchallInfo|bool
     */
    public function hostingMailCatchallInfo($iDSession, $domain)
    {
        try {
            $this->setResult(self::getSoapClient()->hostingMailCatchallInfo($iDSession, $domain));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|\netim\StructType\StructHostingInfo|\netim\StructType\StructHostingMailAliasesInfo|\netim\StructType\StructHostingMailCatchallInfo|\netim\StructType\StructHostingMailDomainAliasesInfo|\netim\StructType\StructHostingMailFwdInfo|\netim\StructType\StructHostingMailInfo
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
