<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Host ServiceType
 * @subpackage Services
 */
class Host extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hostCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $host
     * @param string $ipv4
     * @param string $ipv6
     * @return int|bool
     */
    public function hostCreate($iDSession, $host, $ipv4, $ipv6)
    {
        try {
            $this->setResult(self::getSoapClient()->hostCreate($iDSession, $host, $ipv4, $ipv6));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $host
     * @return int|bool
     */
    public function hostDelete($iDSession, $host)
    {
        try {
            $this->setResult(self::getSoapClient()->hostDelete($iDSession, $host));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hostUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $host
     * @param string $ipv4
     * @param string $ipv6
     * @return int|bool
     */
    public function hostUpdate($iDSession, $host, $ipv4, $ipv6)
    {
        try {
            $this->setResult(self::getSoapClient()->hostUpdate($iDSession, $host, $ipv4, $ipv6));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
