<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoluntaryChanges StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies charges and/or penalties associated with making ticket changes after purchase. | Identifies whether penalties associated with voluntary changes should be included in the search results.
 * @subpackage Structs
 */
class VoluntaryChanges extends AbstractStructBase
{
    /**
     * The Penalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Penalty[]
     */
    public $Penalty;
    /**
     * The Match
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Match;
    /**
     * Constructor method for VoluntaryChanges
     * @uses VoluntaryChanges::setPenalty()
     * @uses VoluntaryChanges::setMatch()
     * @param \SabreSoap\StructType\Penalty[] $penalty
     * @param string $match
     */
    public function __construct(array $penalty = array(), $match = null)
    {
        $this
            ->setPenalty($penalty)
            ->setMatch($match);
    }
    /**
     * Get Penalty value
     * @return \SabreSoap\StructType\Penalty[]|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * Set Penalty value
     * @param \SabreSoap\StructType\Penalty[] $penalty
     * @return \SabreSoap\StructType\VoluntaryChanges
     */
    public function setPenalty(array $penalty = array())
    {
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Add item to Penalty value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Penalty $item
     * @return \SabreSoap\StructType\VoluntaryChanges
     */
    public function addToPenalty(\SabreSoap\StructType\Penalty $item)
    {
        $this->Penalty[] = $item;
        return $this;
    }
    /**
     * Get Match value
     * @return string|null
     */
    public function getMatch()
    {
        return $this->Match;
    }
    /**
     * Set Match value
     * @param string $match
     * @return \SabreSoap\StructType\VoluntaryChanges
     */
    public function setMatch($match = null)
    {
        $this->Match = $match;
        return $this;
    }
}
