<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneType StructType
 * Meta information extracted from the WSDL
 * - documentation: Construct for holding a telephone number.
 * @subpackage Structs
 */
class TelephoneType extends AbstractStructBase
{
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Telephone number assigned to a single location. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: required
     * @var string
     */
    public $PhoneNumber;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PhoneLocationType
     * Meta information extracted from the WSDL
     * - documentation: Refer to OTA Code List Phone Location Type (PLT). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneLocationType;
    /**
     * The PhoneTechType
     * Meta information extracted from the WSDL
     * - documentation: Indicates type of technology associated with this telephone number, such as Voice, Data, Fax, Pager, Mobile, TTY, etc. Refer to OTA Code List Phone Technology Type (PTT). | Used for codes in the OTA code tables. Possible values of
     * this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $PhoneTechType;
    /**
     * The CountryAccessCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned by telecommunications authorities for international country access identifier. | Used for Numeric Strings, minimum length 1, maximum length 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - type: NumericStringLength1to3
     * - use: optional
     * @var string
     */
    public $CountryAccessCode;
    /**
     * The AreaCityCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned for telephones in a specific region, city, or area. | Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: NumericStringLength1to8
     * - use: optional
     * @var string
     */
    public $AreaCityCode;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - documentation: Extension to reach a specific party at the phone number. | Used for Numeric Strings, length 1 to 5
     * - base: xs:string
     * - pattern: [0-9]{1,5}
     * - type: NumericStringLength1to5
     * - use: optional
     * @var string
     */
    public $Extension;
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - documentation: Additional codes used for pager or telephone access rights. | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $PIN;
    /**
     * The FormattedInd
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the associated data is formatted or not. If true, then it is formatted, if false, then not formatted.
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $FormattedInd;
    /**
     * Constructor method for TelephoneType
     * @uses TelephoneType::setPhoneNumber()
     * @uses TelephoneType::setShareSynchInd()
     * @uses TelephoneType::setShareMarketInd()
     * @uses TelephoneType::setPhoneLocationType()
     * @uses TelephoneType::setPhoneTechType()
     * @uses TelephoneType::setCountryAccessCode()
     * @uses TelephoneType::setAreaCityCode()
     * @uses TelephoneType::setExtension()
     * @uses TelephoneType::setPIN()
     * @uses TelephoneType::setFormattedInd()
     * @param string $phoneNumber
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $phoneLocationType
     * @param string $phoneTechType
     * @param string $countryAccessCode
     * @param string $areaCityCode
     * @param string $extension
     * @param string $pIN
     * @param bool $formattedInd
     */
    public function __construct($phoneNumber = null, $shareSynchInd = null, $shareMarketInd = null, $phoneLocationType = null, $phoneTechType = null, $countryAccessCode = null, $areaCityCode = null, $extension = null, $pIN = null, $formattedInd = false)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPhoneLocationType($phoneLocationType)
            ->setPhoneTechType($phoneTechType)
            ->setCountryAccessCode($countryAccessCode)
            ->setAreaCityCode($areaCityCode)
            ->setExtension($extension)
            ->setPIN($pIN)
            ->setFormattedInd($formattedInd);
    }
    /**
     * Get PhoneNumber value
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PhoneLocationType value
     * @return string|null
     */
    public function getPhoneLocationType()
    {
        return $this->PhoneLocationType;
    }
    /**
     * Set PhoneLocationType value
     * @param string $phoneLocationType
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setPhoneLocationType($phoneLocationType = null)
    {
        $this->PhoneLocationType = $phoneLocationType;
        return $this;
    }
    /**
     * Get PhoneTechType value
     * @return string|null
     */
    public function getPhoneTechType()
    {
        return $this->PhoneTechType;
    }
    /**
     * Set PhoneTechType value
     * @param string $phoneTechType
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setPhoneTechType($phoneTechType = null)
    {
        $this->PhoneTechType = $phoneTechType;
        return $this;
    }
    /**
     * Get CountryAccessCode value
     * @return string|null
     */
    public function getCountryAccessCode()
    {
        return $this->CountryAccessCode;
    }
    /**
     * Set CountryAccessCode value
     * @param string $countryAccessCode
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setCountryAccessCode($countryAccessCode = null)
    {
        $this->CountryAccessCode = $countryAccessCode;
        return $this;
    }
    /**
     * Get AreaCityCode value
     * @return string|null
     */
    public function getAreaCityCode()
    {
        return $this->AreaCityCode;
    }
    /**
     * Set AreaCityCode value
     * @param string $areaCityCode
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setAreaCityCode($areaCityCode = null)
    {
        $this->AreaCityCode = $areaCityCode;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setExtension($extension = null)
    {
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setPIN($pIN = null)
    {
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return bool|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param bool $formattedInd
     * @return \SabreSoap\StructType\TelephoneType
     */
    public function setFormattedInd($formattedInd = false)
    {
        $this->FormattedInd = $formattedInd;
        return $this;
    }
}
