<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType StructType
 * @subpackage Structs
 */
class SourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * @var \SabreSoap\StructType\UniqueID_Type
     */
    public $RequestorID;
    /**
     * The Position
     * @var \SabreSoap\StructType\PositionType
     */
    public $Position;
    /**
     * The BookingChannel
     * @var \SabreSoap\StructType\SourceBookingChannelType
     */
    public $BookingChannel;
    /**
     * The AgentSine
     * Meta information extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * Meta information extracted from the WSDL
     * - documentation: The country code of the requesting party. | 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - type: ISO3166
     * - use: optional
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * Meta information extracted from the WSDL
     * - documentation: The currency code in which the reservation will be ticketed. | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: optional
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * Meta information extracted from the WSDL
     * - documentation: An authority code assigned to a requestor. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airline code. | Used for an Upper Alpha String and Numeric, length 2 to 3.
     * - base: xs:string
     * - pattern: [A-Z0-9]{2,3}
     * - type: UpperCaseAlphaNumericLength2to3
     * - use: optional
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airport code. | Used for an Upper Alpha String and Numeric, length 3 to 5.
     * - base: xs:string
     * - pattern: [A-Z0-9]{3,5}
     * - type: UpperCaseAlphaNumericLength3to5
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * Meta information extracted from the WSDL
     * - documentation: The point of first departure in a trip. | Used for Strings, length exactly 3
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - type: StringLength3
     * - use: optional
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The ERSP_UserID
     * Meta information extracted from the WSDL
     * - documentation: Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The PersonalCityCode
     * @var string
     */
    public $PersonalCityCode;
    /**
     * The AccountingCode
     * @var string
     */
    public $AccountingCode;
    /**
     * The OfficeCode
     * @var string
     */
    public $OfficeCode;
    /**
     * The DefaultTicketingCarrier
     * @var string
     */
    public $DefaultTicketingCarrier;
    /**
     * The AgentCity
     * Meta information extracted from the WSDL
     * - documentation: Agent city | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * @var string
     */
    public $AgentCity;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: Carrier
     * - base: xs:string
     * - pattern: [0-9A-Z]{2,3}
     * - type: CarrierCode
     * - use: optional
     * @var string
     */
    public $Carrier;
    /**
     * The MainTravelAgencyPCC
     * Meta information extracted from the WSDL
     * - documentation: Main travel agency PCC | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * @var string
     */
    public $MainTravelAgencyPCC;
    /**
     * Constructor method for SourceType
     * @uses SourceType::setRequestorID()
     * @uses SourceType::setPosition()
     * @uses SourceType::setBookingChannel()
     * @uses SourceType::setAgentSine()
     * @uses SourceType::setPseudoCityCode()
     * @uses SourceType::setISOCountry()
     * @uses SourceType::setISOCurrency()
     * @uses SourceType::setAgentDutyCode()
     * @uses SourceType::setAirlineVendorID()
     * @uses SourceType::setAirportCode()
     * @uses SourceType::setFirstDepartPoint()
     * @uses SourceType::setERSP_UserID()
     * @uses SourceType::setPersonalCityCode()
     * @uses SourceType::setAccountingCode()
     * @uses SourceType::setOfficeCode()
     * @uses SourceType::setDefaultTicketingCarrier()
     * @uses SourceType::setAgentCity()
     * @uses SourceType::setCarrier()
     * @uses SourceType::setMainTravelAgencyPCC()
     * @param \SabreSoap\StructType\UniqueID_Type $requestorID
     * @param \SabreSoap\StructType\PositionType $position
     * @param \SabreSoap\StructType\SourceBookingChannelType $bookingChannel
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $eRSP_UserID
     * @param string $personalCityCode
     * @param string $accountingCode
     * @param string $officeCode
     * @param string $defaultTicketingCarrier
     * @param string $agentCity
     * @param string $carrier
     * @param string $mainTravelAgencyPCC
     */
    public function __construct(\SabreSoap\StructType\UniqueID_Type $requestorID = null, \SabreSoap\StructType\PositionType $position = null, \SabreSoap\StructType\SourceBookingChannelType $bookingChannel = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $eRSP_UserID = null, $personalCityCode = null, $accountingCode = null, $officeCode = null, $defaultTicketingCarrier = null, $agentCity = null, $carrier = null, $mainTravelAgencyPCC = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setPosition($position)
            ->setBookingChannel($bookingChannel)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setERSP_UserID($eRSP_UserID)
            ->setPersonalCityCode($personalCityCode)
            ->setAccountingCode($accountingCode)
            ->setOfficeCode($officeCode)
            ->setDefaultTicketingCarrier($defaultTicketingCarrier)
            ->setAgentCity($agentCity)
            ->setCarrier($carrier)
            ->setMainTravelAgencyPCC($mainTravelAgencyPCC);
    }
    /**
     * Get RequestorID value
     * @return \SabreSoap\StructType\UniqueID_Type|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \SabreSoap\StructType\UniqueID_Type $requestorID
     * @return \SabreSoap\StructType\SourceType
     */
    public function setRequestorID(\SabreSoap\StructType\UniqueID_Type $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get Position value
     * @return \SabreSoap\StructType\PositionType|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \SabreSoap\StructType\PositionType $position
     * @return \SabreSoap\StructType\SourceType
     */
    public function setPosition(\SabreSoap\StructType\PositionType $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \SabreSoap\StructType\SourceBookingChannelType|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \SabreSoap\StructType\SourceBookingChannelType $bookingChannel
     * @return \SabreSoap\StructType\SourceType
     */
    public function setBookingChannel(\SabreSoap\StructType\SourceBookingChannelType $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \SabreSoap\StructType\SourceType
     */
    public function setAgentSine($agentSine = null)
    {
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \SabreSoap\StructType\SourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \SabreSoap\StructType\SourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \SabreSoap\StructType\SourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \SabreSoap\StructType\SourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \SabreSoap\StructType\SourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \SabreSoap\StructType\SourceType
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \SabreSoap\StructType\SourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \SabreSoap\StructType\SourceType
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get PersonalCityCode value
     * @return string|null
     */
    public function getPersonalCityCode()
    {
        return $this->PersonalCityCode;
    }
    /**
     * Set PersonalCityCode value
     * @param string $personalCityCode
     * @return \SabreSoap\StructType\SourceType
     */
    public function setPersonalCityCode($personalCityCode = null)
    {
        $this->PersonalCityCode = $personalCityCode;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \SabreSoap\StructType\SourceType
     */
    public function setAccountingCode($accountingCode = null)
    {
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get OfficeCode value
     * @return string|null
     */
    public function getOfficeCode()
    {
        return $this->OfficeCode;
    }
    /**
     * Set OfficeCode value
     * @param string $officeCode
     * @return \SabreSoap\StructType\SourceType
     */
    public function setOfficeCode($officeCode = null)
    {
        $this->OfficeCode = $officeCode;
        return $this;
    }
    /**
     * Get DefaultTicketingCarrier value
     * @return string|null
     */
    public function getDefaultTicketingCarrier()
    {
        return $this->DefaultTicketingCarrier;
    }
    /**
     * Set DefaultTicketingCarrier value
     * @param string $defaultTicketingCarrier
     * @return \SabreSoap\StructType\SourceType
     */
    public function setDefaultTicketingCarrier($defaultTicketingCarrier = null)
    {
        $this->DefaultTicketingCarrier = $defaultTicketingCarrier;
        return $this;
    }
    /**
     * Get AgentCity value
     * @return string|null
     */
    public function getAgentCity()
    {
        return $this->AgentCity;
    }
    /**
     * Set AgentCity value
     * @param string $agentCity
     * @return \SabreSoap\StructType\SourceType
     */
    public function setAgentCity($agentCity = null)
    {
        $this->AgentCity = $agentCity;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \SabreSoap\StructType\SourceType
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get MainTravelAgencyPCC value
     * @return string|null
     */
    public function getMainTravelAgencyPCC()
    {
        return $this->MainTravelAgencyPCC;
    }
    /**
     * Set MainTravelAgencyPCC value
     * @param string $mainTravelAgencyPCC
     * @return \SabreSoap\StructType\SourceType
     */
    public function setMainTravelAgencyPCC($mainTravelAgencyPCC = null)
    {
        $this->MainTravelAgencyPCC = $mainTravelAgencyPCC;
        return $this;
    }
}
