<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRestrictPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Constrains a fare search to those with restrictions that satisfy user-imposed limitations.
 * @subpackage Structs
 */
class FareRestrictPref extends FareRestrictPrefType
{
    /**
     * The AdvResTicketing
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether advance reservation or ticketing restrictions are acceptable in the search results.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AdvResTicketingType
     */
    public $AdvResTicketing;
    /**
     * The StayRestrictions
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether restrictions on minimum or maximum stays should be included in the search results.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\StayRestrictionsType
     */
    public $StayRestrictions;
    /**
     * The VoluntaryChanges
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether penalties associated with voluntary changes should be included in the search results.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\VoluntaryChangesType
     */
    public $VoluntaryChanges;
    /**
     * Constructor method for FareRestrictPref
     * @uses FareRestrictPref::setAdvResTicketing()
     * @uses FareRestrictPref::setStayRestrictions()
     * @uses FareRestrictPref::setVoluntaryChanges()
     * @param \SabreSoap\StructType\AdvResTicketingType $advResTicketing
     * @param \SabreSoap\StructType\StayRestrictionsType $stayRestrictions
     * @param \SabreSoap\StructType\VoluntaryChangesType $voluntaryChanges
     */
    public function __construct(\SabreSoap\StructType\AdvResTicketingType $advResTicketing = null, \SabreSoap\StructType\StayRestrictionsType $stayRestrictions = null, \SabreSoap\StructType\VoluntaryChangesType $voluntaryChanges = null)
    {
        $this
            ->setAdvResTicketing($advResTicketing)
            ->setStayRestrictions($stayRestrictions)
            ->setVoluntaryChanges($voluntaryChanges);
    }
    /**
     * Get AdvResTicketing value
     * @return \SabreSoap\StructType\AdvResTicketingType|null
     */
    public function getAdvResTicketing()
    {
        return $this->AdvResTicketing;
    }
    /**
     * Set AdvResTicketing value
     * @param \SabreSoap\StructType\AdvResTicketingType $advResTicketing
     * @return \SabreSoap\StructType\FareRestrictPref
     */
    public function setAdvResTicketing(\SabreSoap\StructType\AdvResTicketingType $advResTicketing = null)
    {
        $this->AdvResTicketing = $advResTicketing;
        return $this;
    }
    /**
     * Get StayRestrictions value
     * @return \SabreSoap\StructType\StayRestrictionsType|null
     */
    public function getStayRestrictions()
    {
        return $this->StayRestrictions;
    }
    /**
     * Set StayRestrictions value
     * @param \SabreSoap\StructType\StayRestrictionsType $stayRestrictions
     * @return \SabreSoap\StructType\FareRestrictPref
     */
    public function setStayRestrictions(\SabreSoap\StructType\StayRestrictionsType $stayRestrictions = null)
    {
        $this->StayRestrictions = $stayRestrictions;
        return $this;
    }
    /**
     * Get VoluntaryChanges value
     * @return \SabreSoap\StructType\VoluntaryChangesType|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param \SabreSoap\StructType\VoluntaryChangesType $voluntaryChanges
     * @return \SabreSoap\StructType\FareRestrictPref
     */
    public function setVoluntaryChanges(\SabreSoap\StructType\VoluntaryChangesType $voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
}
