<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBasisCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Fare basis code for the price for this PTC | Used for Character Strings, length 1 to 16
 * - base: xs:string
 * - maxLength: 16
 * - minLength: 1
 * @subpackage Structs
 */
class FareBasisCode extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The PrivateFareType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 1
     * @var string
     */
    public $PrivateFareType;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - documentation: Matched Account Code | Used for Character Strings, length 1 to 20
     * - base: xs:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $AccountCode;
    /**
     * The Mileage
     * Meta information extracted from the WSDL
     * - documentation: Mileage (AWARD Shopping)
     * @var int
     */
    public $Mileage;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 1
     * @var string
     */
    public $BookingCode;
    /**
     * The AvailabilityBreak
     * Meta information extracted from the WSDL
     * - documentation: Availability break after this segment
     * @var bool
     */
    public $AvailabilityBreak;
    /**
     * The DepartureAirportCode
     * @var string
     */
    public $DepartureAirportCode;
    /**
     * The ArrivalAirportCode
     * @var string
     */
    public $ArrivalAirportCode;
    /**
     * Constructor method for FareBasisCode
     * @uses FareBasisCode::set_()
     * @uses FareBasisCode::setPrivateFareType()
     * @uses FareBasisCode::setAccountCode()
     * @uses FareBasisCode::setMileage()
     * @uses FareBasisCode::setBookingCode()
     * @uses FareBasisCode::setAvailabilityBreak()
     * @uses FareBasisCode::setDepartureAirportCode()
     * @uses FareBasisCode::setArrivalAirportCode()
     * @param string $_
     * @param string $privateFareType
     * @param string $accountCode
     * @param int $mileage
     * @param string $bookingCode
     * @param bool $availabilityBreak
     * @param string $departureAirportCode
     * @param string $arrivalAirportCode
     */
    public function __construct($_ = null, $privateFareType = null, $accountCode = null, $mileage = null, $bookingCode = null, $availabilityBreak = null, $departureAirportCode = null, $arrivalAirportCode = null)
    {
        $this
            ->set_($_)
            ->setPrivateFareType($privateFareType)
            ->setAccountCode($accountCode)
            ->setMileage($mileage)
            ->setBookingCode($bookingCode)
            ->setAvailabilityBreak($availabilityBreak)
            ->setDepartureAirportCode($departureAirportCode)
            ->setArrivalAirportCode($arrivalAirportCode);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PrivateFareType value
     * @return string|null
     */
    public function getPrivateFareType()
    {
        return $this->PrivateFareType;
    }
    /**
     * Set PrivateFareType value
     * @param string $privateFareType
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function setPrivateFareType($privateFareType = null)
    {
        $this->PrivateFareType = $privateFareType;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function setAccountCode($accountCode = null)
    {
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get Mileage value
     * @return int|null
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param int $mileage
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function setMileage($mileage = null)
    {
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function setBookingCode($bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get AvailabilityBreak value
     * @return bool|null
     */
    public function getAvailabilityBreak()
    {
        return $this->AvailabilityBreak;
    }
    /**
     * Set AvailabilityBreak value
     * @param bool $availabilityBreak
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function setAvailabilityBreak($availabilityBreak = null)
    {
        $this->AvailabilityBreak = $availabilityBreak;
        return $this;
    }
    /**
     * Get DepartureAirportCode value
     * @return string|null
     */
    public function getDepartureAirportCode()
    {
        return $this->DepartureAirportCode;
    }
    /**
     * Set DepartureAirportCode value
     * @param string $departureAirportCode
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function setDepartureAirportCode($departureAirportCode = null)
    {
        $this->DepartureAirportCode = $departureAirportCode;
        return $this;
    }
    /**
     * Get ArrivalAirportCode value
     * @return string|null
     */
    public function getArrivalAirportCode()
    {
        return $this->ArrivalAirportCode;
    }
    /**
     * Set ArrivalAirportCode value
     * @param string $arrivalAirportCode
     * @return \SabreSoap\StructType\FareBasisCode
     */
    public function setArrivalAirportCode($arrivalAirportCode = null)
    {
        $this->ArrivalAirportCode = $arrivalAirportCode;
        return $this;
    }
}
