<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvReservation StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies constraints on date of advance reservations.
 * @subpackage Structs
 */
class AdvReservation extends AbstractStructBase
{
    /**
     * The LatestTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day by which reservations must be made on the last day that advance reservations can be made. | Allows for the specification of a date time or just time.
     * - union: string | time
     * - use: optional
     * @var string
     */
    public $LatestTimeOfDay;
    /**
     * The LatestPeriod
     * Meta information extracted from the WSDL
     * - documentation: The amount of elapsed time or number of occurrences of a day of the week before departure needed to satisfy an advance reservation requirement. | Used for Numeric Strings, minimum length 1, maximum length 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - use: optional
     * @var string
     */
    public $LatestPeriod;
    /**
     * The LatestUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week to be applied to the LatestPeriod value.
     * - use: optional
     * @var string
     */
    public $LatestUnit;
    /**
     * Constructor method for AdvReservation
     * @uses AdvReservation::setLatestTimeOfDay()
     * @uses AdvReservation::setLatestPeriod()
     * @uses AdvReservation::setLatestUnit()
     * @param string $latestTimeOfDay
     * @param string $latestPeriod
     * @param string $latestUnit
     */
    public function __construct($latestTimeOfDay = null, $latestPeriod = null, $latestUnit = null)
    {
        $this
            ->setLatestTimeOfDay($latestTimeOfDay)
            ->setLatestPeriod($latestPeriod)
            ->setLatestUnit($latestUnit);
    }
    /**
     * Get LatestTimeOfDay value
     * @return string|null
     */
    public function getLatestTimeOfDay()
    {
        return $this->LatestTimeOfDay;
    }
    /**
     * Set LatestTimeOfDay value
     * @param string $latestTimeOfDay
     * @return \SabreSoap\StructType\AdvReservation
     */
    public function setLatestTimeOfDay($latestTimeOfDay = null)
    {
        $this->LatestTimeOfDay = $latestTimeOfDay;
        return $this;
    }
    /**
     * Get LatestPeriod value
     * @return string|null
     */
    public function getLatestPeriod()
    {
        return $this->LatestPeriod;
    }
    /**
     * Set LatestPeriod value
     * @param string $latestPeriod
     * @return \SabreSoap\StructType\AdvReservation
     */
    public function setLatestPeriod($latestPeriod = null)
    {
        $this->LatestPeriod = $latestPeriod;
        return $this;
    }
    /**
     * Get LatestUnit value
     * @return string|null
     */
    public function getLatestUnit()
    {
        return $this->LatestUnit;
    }
    /**
     * Set LatestUnit value
     * @param string $latestUnit
     * @return \SabreSoap\StructType\AdvReservation
     */
    public function setLatestUnit($latestUnit = null)
    {
        $this->LatestUnit = $latestUnit;
        return $this;
    }
}
