<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueID_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: An identifier used to uniquely reference an object in a system (e.g. an airline reservation reference, customer profile reference, booking confirmation number, or a reference to a previous availability quote).
 * @subpackage Structs
 */
class UniqueID_Type extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: A reference to the type of object defined by the UniqueID element. Refer to OTA Code List Unique ID Type (UIT). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - type: OTA_CodeType
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: required
     * @var string
     */
    public $ID;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Identifies the company that is associated with the UniqueID.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: URL that identifies the location associated with the record identified by the UniqueID.
     * - type: xs:anyURI
     * @var string
     */
    public $URL;
    /**
     * The Instance
     * Meta information extracted from the WSDL
     * - documentation: The identification of a record as it exists at a point in time. An instance is used in update messages where the sender must assure the server that the update sent refers to the most recent modification level of the object being
     * updated. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * @var string
     */
    public $Instance;
    /**
     * The ID_Context
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the source of the identifier (e.g. IATA, ABTA, etc.). | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $ID_Context;
    /**
     * Constructor method for UniqueID_Type
     * @uses UniqueID_Type::setType()
     * @uses UniqueID_Type::setID()
     * @uses UniqueID_Type::setCompanyName()
     * @uses UniqueID_Type::setURL()
     * @uses UniqueID_Type::setInstance()
     * @uses UniqueID_Type::setID_Context()
     * @param string $type
     * @param string $iD
     * @param \SabreSoap\StructType\CompanyNameType $companyName
     * @param string $uRL
     * @param string $instance
     * @param string $iD_Context
     */
    public function __construct($type = null, $iD = null, \SabreSoap\StructType\CompanyNameType $companyName = null, $uRL = null, $instance = null, $iD_Context = null)
    {
        $this
            ->setType($type)
            ->setID($iD)
            ->setCompanyName($companyName)
            ->setURL($uRL)
            ->setInstance($instance)
            ->setID_Context($iD_Context);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\UniqueID_Type
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \SabreSoap\StructType\UniqueID_Type
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return \SabreSoap\StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \SabreSoap\StructType\CompanyNameType $companyName
     * @return \SabreSoap\StructType\UniqueID_Type
     */
    public function setCompanyName(\SabreSoap\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \SabreSoap\StructType\UniqueID_Type
     */
    public function setURL($uRL = null)
    {
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Instance value
     * @return string|null
     */
    public function getInstance()
    {
        return $this->Instance;
    }
    /**
     * Set Instance value
     * @param string $instance
     * @return \SabreSoap\StructType\UniqueID_Type
     */
    public function setInstance($instance = null)
    {
        $this->Instance = $instance;
        return $this;
    }
    /**
     * Get ID_Context value
     * @return string|null
     */
    public function getID_Context()
    {
        return $this->ID_Context;
    }
    /**
     * Set ID_Context value
     * @param string $iD_Context
     * @return \SabreSoap\StructType\UniqueID_Type
     */
    public function setID_Context($iD_Context = null)
    {
        $this->ID_Context = $iD_Context;
        return $this;
    }
}
