<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiversityParameters StructType
 * @subpackage Structs
 */
class DiversityParameters extends AbstractStructBase
{
    /**
     * The Weightings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Weightings
     */
    public $Weightings;
    /**
     * The TimeOfDayDistribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TimeOfDayDistribution
     */
    public $TimeOfDayDistribution;
    /**
     * The InboundOutboundPairing
     * Meta information extracted from the WSDL
     * - base: xs:unsignedShort
     * - maxInclusive: 1000
     * - minInclusive: 1
     * @var int
     */
    public $InboundOutboundPairing;
    /**
     * The AdditionalNonStopsNumber
     * Meta information extracted from the WSDL
     * - base: xs:unsignedShort
     * - minInclusive: 1
     * @var int
     */
    public $AdditionalNonStopsNumber;
    /**
     * The AdditionalNonStopsPercentage
     * Meta information extracted from the WSDL
     * - documentation: Defines how many additional non-stop options should be added to the response as a percentage of the requested number of options.
     * - base: xs:unsignedShort
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var int
     */
    public $AdditionalNonStopsPercentage;
    /**
     * Constructor method for DiversityParameters
     * @uses DiversityParameters::setWeightings()
     * @uses DiversityParameters::setTimeOfDayDistribution()
     * @uses DiversityParameters::setInboundOutboundPairing()
     * @uses DiversityParameters::setAdditionalNonStopsNumber()
     * @uses DiversityParameters::setAdditionalNonStopsPercentage()
     * @param \SabreSoap\StructType\Weightings $weightings
     * @param \SabreSoap\StructType\TimeOfDayDistribution $timeOfDayDistribution
     * @param int $inboundOutboundPairing
     * @param int $additionalNonStopsNumber
     * @param int $additionalNonStopsPercentage
     */
    public function __construct(\SabreSoap\StructType\Weightings $weightings = null, \SabreSoap\StructType\TimeOfDayDistribution $timeOfDayDistribution = null, $inboundOutboundPairing = null, $additionalNonStopsNumber = null, $additionalNonStopsPercentage = null)
    {
        $this
            ->setWeightings($weightings)
            ->setTimeOfDayDistribution($timeOfDayDistribution)
            ->setInboundOutboundPairing($inboundOutboundPairing)
            ->setAdditionalNonStopsNumber($additionalNonStopsNumber)
            ->setAdditionalNonStopsPercentage($additionalNonStopsPercentage);
    }
    /**
     * Get Weightings value
     * @return \SabreSoap\StructType\Weightings|null
     */
    public function getWeightings()
    {
        return $this->Weightings;
    }
    /**
     * Set Weightings value
     * @param \SabreSoap\StructType\Weightings $weightings
     * @return \SabreSoap\StructType\DiversityParameters
     */
    public function setWeightings(\SabreSoap\StructType\Weightings $weightings = null)
    {
        $this->Weightings = $weightings;
        return $this;
    }
    /**
     * Get TimeOfDayDistribution value
     * @return \SabreSoap\StructType\TimeOfDayDistribution|null
     */
    public function getTimeOfDayDistribution()
    {
        return $this->TimeOfDayDistribution;
    }
    /**
     * Set TimeOfDayDistribution value
     * @param \SabreSoap\StructType\TimeOfDayDistribution $timeOfDayDistribution
     * @return \SabreSoap\StructType\DiversityParameters
     */
    public function setTimeOfDayDistribution(\SabreSoap\StructType\TimeOfDayDistribution $timeOfDayDistribution = null)
    {
        $this->TimeOfDayDistribution = $timeOfDayDistribution;
        return $this;
    }
    /**
     * Get InboundOutboundPairing value
     * @return int|null
     */
    public function getInboundOutboundPairing()
    {
        return $this->InboundOutboundPairing;
    }
    /**
     * Set InboundOutboundPairing value
     * @param int $inboundOutboundPairing
     * @return \SabreSoap\StructType\DiversityParameters
     */
    public function setInboundOutboundPairing($inboundOutboundPairing = null)
    {
        $this->InboundOutboundPairing = $inboundOutboundPairing;
        return $this;
    }
    /**
     * Get AdditionalNonStopsNumber value
     * @return int|null
     */
    public function getAdditionalNonStopsNumber()
    {
        return $this->AdditionalNonStopsNumber;
    }
    /**
     * Set AdditionalNonStopsNumber value
     * @param int $additionalNonStopsNumber
     * @return \SabreSoap\StructType\DiversityParameters
     */
    public function setAdditionalNonStopsNumber($additionalNonStopsNumber = null)
    {
        $this->AdditionalNonStopsNumber = $additionalNonStopsNumber;
        return $this;
    }
    /**
     * Get AdditionalNonStopsPercentage value
     * @return int|null
     */
    public function getAdditionalNonStopsPercentage()
    {
        return $this->AdditionalNonStopsPercentage;
    }
    /**
     * Set AdditionalNonStopsPercentage value
     * @param int $additionalNonStopsPercentage
     * @return \SabreSoap\StructType\DiversityParameters
     */
    public function setAdditionalNonStopsPercentage($additionalNonStopsPercentage = null)
    {
        $this->AdditionalNonStopsPercentage = $additionalNonStopsPercentage;
        return $this;
    }
}
