<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerRating StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer Value Scores and Frequent Flyer Tiers for one traveler. It can influence Availability results when provided.
 * @subpackage Structs
 */
class TravelerRating extends AbstractStructBase
{
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Score[]
     */
    public $Score;
    /**
     * Constructor method for TravelerRating
     * @uses TravelerRating::setScore()
     * @param \SabreSoap\StructType\Score[] $score
     */
    public function __construct(array $score = array())
    {
        $this
            ->setScore($score);
    }
    /**
     * Get Score value
     * @return \SabreSoap\StructType\Score[]|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param \SabreSoap\StructType\Score[] $score
     * @return \SabreSoap\StructType\TravelerRating
     */
    public function setScore(array $score = array())
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Add item to Score value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Score $item
     * @return \SabreSoap\StructType\TravelerRating
     */
    public function addToScore(\SabreSoap\StructType\Score $item)
    {
        $this->Score[] = $item;
        return $this;
    }
}
