<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransformsType StructType
 * @subpackage Structs
 */
class TransformsType extends AbstractStructBase
{
    /**
     * The Transform
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:Transform
     * @var \SabreSoap\StructType\TransformType[]
     */
    public $Transform;
    /**
     * Constructor method for TransformsType
     * @uses TransformsType::setTransform()
     * @param \SabreSoap\StructType\TransformType[] $transform
     */
    public function __construct(array $transform = array())
    {
        $this
            ->setTransform($transform);
    }
    /**
     * Get Transform value
     * @return \SabreSoap\StructType\TransformType[]|null
     */
    public function getTransform()
    {
        return $this->Transform;
    }
    /**
     * Set Transform value
     * @param \SabreSoap\StructType\TransformType[] $transform
     * @return \SabreSoap\StructType\TransformsType
     */
    public function setTransform(array $transform = array())
    {
        $this->Transform = $transform;
        return $this;
    }
    /**
     * Add item to Transform value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\TransformType $item
     * @return \SabreSoap\StructType\TransformsType
     */
    public function addToTransform(\SabreSoap\StructType\TransformType $item)
    {
        $this->Transform[] = $item;
        return $this;
    }
}
