<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * Meta information extracted from the WSDL
 * - documentation: Arbitrary message returned from MIP
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * The AirlineCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $AirlineCode;
    /**
     * The FailCode
     * @var int
     */
    public $FailCode;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: Message text
     * @var string
     */
    public $Info;
    /**
     * Constructor method for Message
     * @uses Message::setType()
     * @uses Message::setText()
     * @uses Message::setAirlineCode()
     * @uses Message::setFailCode()
     * @uses Message::setInfo()
     * @param string $type
     * @param string $text
     * @param string $airlineCode
     * @param int $failCode
     * @param string $info
     */
    public function __construct($type = null, $text = null, $airlineCode = null, $failCode = null, $info = null)
    {
        $this
            ->setType($type)
            ->setText($text)
            ->setAirlineCode($airlineCode)
            ->setFailCode($failCode)
            ->setInfo($info);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\Message
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \SabreSoap\StructType\Message
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \SabreSoap\StructType\Message
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get FailCode value
     * @return int|null
     */
    public function getFailCode()
    {
        return $this->FailCode;
    }
    /**
     * Set FailCode value
     * @param int $failCode
     * @return \SabreSoap\StructType\Message
     */
    public function setFailCode($failCode = null)
    {
        $this->FailCode = $failCode;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \SabreSoap\StructType\Message
     */
    public function setInfo($info = null)
    {
        $this->Info = $info;
        return $this;
    }
}
