<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthOfStay StructType
 * Meta information extracted from the WSDL
 * - documentation: Amount of days between previous leg's DEPARTURE date and current leg's DEPARTURE date. NOTE: Allowed only in 2nd or further "OriginDestinationInformation". Example: for outbound departing on Jan 20, LengthOfStay/@Days="2" means
 * inbound departing on Jan 22.
 * @subpackage Structs
 */
class LengthOfStay extends AbstractStructBase
{
    /**
     * The Days
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Days;
    /**
     * Constructor method for LengthOfStay
     * @uses LengthOfStay::setDays()
     * @param int $days
     */
    public function __construct($days = null)
    {
        $this
            ->setDays($days);
    }
    /**
     * Get Days value
     * @return int
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \SabreSoap\StructType\LengthOfStay
     */
    public function setDays($days = null)
    {
        $this->Days = $days;
        return $this;
    }
}
