<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDistribPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type of ticket distribution to be used with this collection of preferences. | Used for Character Strings, length 0 to 64
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class TicketDistribPrefType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The DistribType
     * Meta information extracted from the WSDL
     * - documentation: Ticket distribution method; such as Fax, Email, Courier, Mail, Airport_Pickup, City_Office, Hotel_Desk, WillCall, etc. | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * @var string
     */
    public $DistribType;
    /**
     * The TicketTime
     * Meta information extracted from the WSDL
     * - documentation: Ticket turnaround time desired, amount of time requested to deliver tickets.
     * @var string
     */
    public $TicketTime;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * - type: PreferLevelType
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for TicketDistribPrefType
     * @uses TicketDistribPrefType::set_()
     * @uses TicketDistribPrefType::setDistribType()
     * @uses TicketDistribPrefType::setTicketTime()
     * @uses TicketDistribPrefType::setPreferLevel()
     * @param string $_
     * @param string $distribType
     * @param string $ticketTime
     * @param string $preferLevel
     */
    public function __construct($_ = null, $distribType = null, $ticketTime = null, $preferLevel = 'Preferred')
    {
        $this
            ->set_($_)
            ->setDistribType($distribType)
            ->setTicketTime($ticketTime)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabreSoap\StructType\TicketDistribPrefType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get DistribType value
     * @return string|null
     */
    public function getDistribType()
    {
        return $this->DistribType;
    }
    /**
     * Set DistribType value
     * @param string $distribType
     * @return \SabreSoap\StructType\TicketDistribPrefType
     */
    public function setDistribType($distribType = null)
    {
        $this->DistribType = $distribType;
        return $this;
    }
    /**
     * Get TicketTime value
     * @return string|null
     */
    public function getTicketTime()
    {
        return $this->TicketTime;
    }
    /**
     * Set TicketTime value
     * @param string $ticketTime
     * @return \SabreSoap\StructType\TicketDistribPrefType
     */
    public function setTicketTime($ticketTime = null)
    {
        $this->TicketTime = $ticketTime;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @param string $preferLevel
     * @return \SabreSoap\StructType\TicketDistribPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
}
