<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TPA_Extensions StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
 * @subpackage Structs
 */
class TPA_Extensions extends AbstractStructBase
{
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\BirthDate
     */
    public $BirthDate;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Age
     */
    public $Age;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\State
     */
    public $State;
    /**
     * The TotalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TotalNumber
     */
    public $TotalNumber;
    /**
     * The VoluntaryChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\VoluntaryChanges
     */
    public $VoluntaryChanges;
    /**
     * The Flight
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OriginDestinationFlightType[]
     */
    public $Flight;
    /**
     * The Routing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\RoutingDefinitionType[]
     */
    public $Routing;
    /**
     * The DateFlexibility
     * @var \SabreSoap\StructType\DateFlexibility
     */
    public $DateFlexibility;
    /**
     * The SisterDestinationLocation
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $SisterDestinationLocation;
    /**
     * The SisterDestinationMileage
     * @var \SabreSoap\StructType\SisterDestinationMileage
     */
    public $SisterDestinationMileage;
    /**
     * The SisterOriginLocation
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $SisterOriginLocation;
    /**
     * The SisterOriginMileage
     * @var \SabreSoap\StructType\SisterOriginMileage
     */
    public $SisterOriginMileage;
    /**
     * The SegmentType
     * @var \SabreSoap\StructType\SegmentType
     */
    public $SegmentType;
    /**
     * The AlternateTime
     * @var \SabreSoap\StructType\AlternateTime
     */
    public $AlternateTime;
    /**
     * The MaxOneWayOptions
     * @var \SabreSoap\StructType\MaxOneWayOptions
     */
    public $MaxOneWayOptions;
    /**
     * The NumOneWayOptions
     * @var \SabreSoap\StructType\NumOneWayOptions
     */
    public $NumOneWayOptions;
    /**
     * The CabinPref
     * @var \SabreSoap\StructType\CabinPrefType
     */
    public $CabinPref;
    /**
     * The ConnectionTime
     * @var \SabreSoap\StructType\ConnectionTime
     */
    public $ConnectionTime;
    /**
     * The TotalTravelTime
     * @var \SabreSoap\StructType\TotalTravelTime
     */
    public $TotalTravelTime;
    /**
     * The IncludeVendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\IncludeVendorPrefType[]
     */
    public $IncludeVendorPref;
    /**
     * The IncludeAlliancePref
     * Meta information extracted from the WSDL
     * - documentation: Consider only these alliances.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AllianceType[]
     */
    public $IncludeAlliancePref;
    /**
     * The DepartureDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DepartureDaysType
     */
    public $DepartureDays;
    /**
     * The IntelliSellTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TransactionType
     */
    public $IntelliSellTransaction;
    /**
     * The DiversityControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DiversityControlType
     */
    public $DiversityControl;
    /**
     * The MessagingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MessagingDetails
     */
    public $MessagingDetails;
    /**
     * The AlternateAirportCities
     * Meta information extracted from the WSDL
     * - choice: AlternateAirportCities | AlternateAirportMileage
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AlternateAirportCities[]
     */
    public $AlternateAirportCities;
    /**
     * The AlternateAirportMileage
     * Meta information extracted from the WSDL
     * - choice: AlternateAirportCities | AlternateAirportMileage
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AlternateAirportMileage
     */
    public $AlternateAirportMileage;
    /**
     * The SplitTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SplitTaxes
     */
    public $SplitTaxes;
    /**
     * The MultiTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MultiTicket
     */
    public $MultiTicket;
    /**
     * The Partitions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Partitions
     */
    public $Partitions;
    /**
     * The ReservationData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ReservationData
     */
    public $ReservationData;
    /**
     * The AlternatePCC
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AlternatePCC[]
     */
    public $AlternatePCC;
    /**
     * The ExcludeAlliancePref
     * Meta information extracted from the WSDL
     * - documentation: Do not consider these alliances.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AllianceType[]
     */
    public $ExcludeAlliancePref;
    /**
     * The PublicFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PublicFare
     */
    public $PublicFare;
    /**
     * The PrivateFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PrivateFare
     */
    public $PrivateFare;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Priority
     */
    public $Priority;
    /**
     * The Indicators
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Indicators
     */
    public $Indicators;
    /**
     * The PromoID
     * Meta information extracted from the WSDL
     * - documentation: Promotional Identifier - a string which identifies a promotion, possibly giving a discount prices etc.
     * - minOccurs: 0
     * @var string
     */
    public $PromoID;
    /**
     * The CustomerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CustomerType
     */
    public $CustomerType;
    /**
     * The MultipleTravelerGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MultipleTravelerGroups
     */
    public $MultipleTravelerGroups;
    /**
     * The BrandedFareIndicators
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\BrandedFareIndicators
     */
    public $BrandedFareIndicators;
    /**
     * The PassengerStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PassengerStatus
     */
    public $PassengerStatus;
    /**
     * The PointOfSaleOverride
     * Meta information extracted from the WSDL
     * - documentation: Will return the fares available for specified point of sale and priced in this point of sale currency. Currency is overriden by PriceRequestInformation@CurrencyCode.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PointOfSaleOverrideType
     */
    public $PointOfSaleOverride;
    /**
     * The PointOfTicketingOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PointOfTicketingOverrideType
     */
    public $PointOfTicketingOverride;
    /**
     * The OBFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OBFees
     */
    public $OBFees;
    /**
     * The FareBreaksAtLegs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareBreaksAtLegs
     */
    public $FareBreaksAtLegs;
    /**
     * The DepartureWindow
     * Meta information extracted from the WSDL
     * - documentation: IntelliSell Time Window type in format HHMMHHMM.
     * - base: xs:string
     * - pattern: ([0-2][0-9][0-5][0-9]){2}
     * @var string
     */
    public $DepartureWindow;
    /**
     * The ArrivalWindow
     * Meta information extracted from the WSDL
     * - documentation: IntelliSell Time Window type in format HHMMHHMM.
     * - base: xs:string
     * - pattern: ([0-2][0-9][0-5][0-9]){2}
     * @var string
     */
    public $ArrivalWindow;
    /**
     * The ExcludeVendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ExcludeVendorPref[]
     */
    public $ExcludeVendorPref;
    /**
     * The NumTrips
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumTripsType
     */
    public $NumTrips;
    /**
     * The AltCitiesCombinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AltCitiesCombinationsType
     */
    public $AltCitiesCombinations;
    /**
     * The NumTripsWithRouting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumTripsWithRouting
     */
    public $NumTripsWithRouting;
    /**
     * The OnlineIndicator
     * @var \SabreSoap\StructType\OnlineIndicator
     */
    public $OnlineIndicator;
    /**
     * The InterlineIndicator
     * @var \SabreSoap\StructType\InterlineIndicator
     */
    public $InterlineIndicator;
    /**
     * The TripType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TripType
     */
    public $TripType;
    /**
     * The MaxPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxPrice
     */
    public $MaxPrice;
    /**
     * The DomesticLayoverTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DomesticLayoverTime
     */
    public $DomesticLayoverTime;
    /**
     * The LongConnectTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\LongConnectTime
     */
    public $LongConnectTime;
    /**
     * The LongConnectPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\LongConnectPoints
     */
    public $LongConnectPoints;
    /**
     * The AirServiceOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirServiceOnly
     */
    public $AirServiceOnly;
    /**
     * The JetServiceOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\JetServiceOnly
     */
    public $JetServiceOnly;
    /**
     * The SameConnectionAirportOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SameConnectionAirportOnly
     */
    public $SameConnectionAirportOnly;
    /**
     * The SameOriginAirportOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SameOriginAirportOnly
     */
    public $SameOriginAirportOnly;
    /**
     * The SameTurnaroundAirportOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SameTurnaroundAirportOnly
     */
    public $SameTurnaroundAirportOnly;
    /**
     * The AircraftTypePenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AircraftTypePenalty
     */
    public $AircraftTypePenalty;
    /**
     * The AlternateAirportPenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AlternateAirportPenalty
     */
    public $AlternateAirportPenalty;
    /**
     * The FareAmountThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareAmountThreshold
     */
    public $FareAmountThreshold;
    /**
     * The numOfLowFareSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfLowFareSol
     */
    public $numOfLowFareSol;
    /**
     * The numOfMustPriceOnlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPriceOnlSol
     */
    public $numOfMustPriceOnlSol;
    /**
     * The numOfMustPriceInrlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPriceInrlSol
     */
    public $numOfMustPriceInrlSol;
    /**
     * The numOfMustPriceNStpOnlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPriceNStpOnlSol
     */
    public $numOfMustPriceNStpOnlSol;
    /**
     * The numOfMustPriceNStpInrlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPriceNStpInrlSol
     */
    public $numOfMustPriceNStpInrlSol;
    /**
     * The numOfMustPriceSStopOnlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPriceSStopOnlSol
     */
    public $numOfMustPriceSStopOnlSol;
    /**
     * The stpPenaltyInUSD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\StpPenaltyInUSD
     */
    public $stpPenaltyInUSD;
    /**
     * The durPenaltyInUSD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DurPenaltyInUSD
     */
    public $durPenaltyInUSD;
    /**
     * The depPenaltyInUSD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DepPenaltyInUSD
     */
    public $depPenaltyInUSD;
    /**
     * The maxAllowedMustPriceOveragePerCrr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxAllowedMustPriceOveragePerCrr
     */
    public $maxAllowedMustPriceOveragePerCrr;
    /**
     * The fltOptMustPriceReuseLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FltOptMustPriceReuseLimit
     */
    public $fltOptMustPriceReuseLimit;
    /**
     * The upperBoundMustPriceFactorForNotNonStp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\UpperBoundMustPriceFactorForNotNonStp
     */
    public $upperBoundMustPriceFactorForNotNonStp;
    /**
     * The upperBoundLFSFactor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\UpperBoundLFSFactor
     */
    public $upperBoundLFSFactor;
    /**
     * The numOfMustPriceNStp1StpOnlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPriceNStp1StpOnlSol
     */
    public $numOfMustPriceNStp1StpOnlSol;
    /**
     * The numOfMustPriceNStp1StpInrlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPriceNStp1StpInrlSol
     */
    public $numOfMustPriceNStp1StpInrlSol;
    /**
     * The upperBoundMustPriceFactorForNonStp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\UpperBoundMustPriceFactorForNonStp
     */
    public $upperBoundMustPriceFactorForNonStp;
    /**
     * The maxAllowedLFSOveragePerCrrPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxAllowedLFSOveragePerCrrPercent
     */
    public $maxAllowedLFSOveragePerCrrPercent;
    /**
     * The targetMinNumOfLFSOnlSolPerCrr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TargetMinNumOfLFSOnlSolPerCrr
     */
    public $targetMinNumOfLFSOnlSolPerCrr;
    /**
     * The targetMinNumOfLFSTotOnlSolPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TargetMinNumOfLFSTotOnlSolPercent
     */
    public $targetMinNumOfLFSTotOnlSolPercent;
    /**
     * The fltOptLFSReuseLimitForNonAVS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FltOptLFSReuseLimitForNonAVS
     */
    public $fltOptLFSReuseLimitForNonAVS;
    /**
     * The fltOptLFSReuseLimitForAVS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FltOptLFSReuseLimitForAVS
     */
    public $fltOptLFSReuseLimitForAVS;
    /**
     * The avsPenaltyCrrs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AvsPenaltyCrrs
     */
    public $avsPenaltyCrrs;
    /**
     * The maxNumOfNonStpOnlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxNumOfNonStpOnlSol
     */
    public $maxNumOfNonStpOnlSol;
    /**
     * The maxNumOfNonStpInrlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxNumOfNonStpInrlSol
     */
    public $maxNumOfNonStpInrlSol;
    /**
     * The maxNumOfSingleStpOnlSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxNumOfSingleStpOnlSol
     */
    public $maxNumOfSingleStpOnlSol;
    /**
     * The maxNumOf2PlusStpSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxNumOf2PlusStpSol
     */
    public $maxNumOf2PlusStpSol;
    /**
     * The minAllowedOveragePerCrrPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MinAllowedOveragePerCrrPercent
     */
    public $minAllowedOveragePerCrrPercent;
    /**
     * The minAllowedOveragePerCrr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MinAllowedOveragePerCrr
     */
    public $minAllowedOveragePerCrr;
    /**
     * The maxRelFareLvlOfxForNonStp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxRelFareLvlOfxForNonStp
     */
    public $maxRelFareLvlOfxForNonStp;
    /**
     * The maxRelFareLvlOfxForCnx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MaxRelFareLvlOfxForCnx
     */
    public $maxRelFareLvlOfxForCnx;
    /**
     * The numOfMustPrice2PlusStpSol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NumOfMustPrice2PlusStpSol
     */
    public $numOfMustPrice2PlusStpSol;
    /**
     * The ItineraryNumberThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ItineraryNumberThreshold
     */
    public $ItineraryNumberThreshold;
    /**
     * The XOFares
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\XOFaresType
     */
    public $XOFares;
    /**
     * The ExemptAllTaxes
     * @var \SabreSoap\StructType\ExemptAllTaxes
     */
    public $ExemptAllTaxes;
    /**
     * The ExemptAllTaxesAndFees
     * @var \SabreSoap\StructType\ExemptAllTaxesAndFees
     */
    public $ExemptAllTaxesAndFees;
    /**
     * The Taxes
     * @var \SabreSoap\StructType\Taxes
     */
    public $Taxes;
    /**
     * The ExemptTax
     * @var \SabreSoap\StructType\TaxCodeType
     */
    public $ExemptTax;
    /**
     * The FlightStopsAsConnections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FlightStopsAsConnectionsType
     */
    public $FlightStopsAsConnections;
    /**
     * The TicketingSumOfLocals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TicketingSumOfLocals
     */
    public $TicketingSumOfLocals;
    /**
     * The JumpCabinLogic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\JumpCabinLogicType
     */
    public $JumpCabinLogic;
    /**
     * The GoverningCarrierOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\GoverningCarrierOverrideType
     */
    public $GoverningCarrierOverride;
    /**
     * The ExcludeCallDirectCarriers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ExcludeCallDirectCarriers
     */
    public $ExcludeCallDirectCarriers;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ValidatingCarrierType
     */
    public $ValidatingCarrier;
    /**
     * The SettlementMethod
     * Meta information extracted from the WSDL
     * - documentation: Overrides settlement method | Supported codes: BSP ARC TCH GEN (Generic TAT) RUT (Russian TAT) PRT (Philippines TAT) SAT (SATA) KRY (Killroy)
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [a-zA-Z0-9]{3}
     * @var string
     */
    public $SettlementMethod;
    /**
     * The FlexibleFares
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FlexibleFaresType
     */
    public $FlexibleFares;
    /**
     * The DiversityParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DiversityParameters
     */
    public $DiversityParameters;
    /**
     * The AdditionalFareLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AdditionalFareLimit
     */
    public $AdditionalFareLimit;
    /**
     * The OptionsPerDatePairList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OptionsPerDatePairList
     */
    public $OptionsPerDatePairList;
    /**
     * The ProcessingMessage
     * Meta information extracted from the WSDL
     * - documentation: Container for itinerary message type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ComplexProcessingMessageType[]
     */
    public $ProcessingMessage;
    /**
     * The AirlineOrderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirlineOrderList
     */
    public $AirlineOrderList;
    /**
     * The SeatsRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SeatsRemaining
     */
    public $SeatsRemaining;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Cabin
     */
    public $Cabin;
    /**
     * The FareNote
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareNote[]
     */
    public $FareNote;
    /**
     * The Meal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Meal
     */
    public $Meal;
    /**
     * The Rule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Rule[]
     */
    public $Rule;
    /**
     * The DivideInParty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DivideInParty
     */
    public $DivideInParty;
    /**
     * The PromoOffer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PromoOffer
     */
    public $PromoOffer;
    /**
     * The PromoRedemption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PromoRedemption
     */
    public $PromoRedemption;
    /**
     * The AncillaryFeeGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AncillaryFeeGroups
     */
    public $AncillaryFeeGroups;
    /**
     * The Legs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Legs
     */
    public $Legs;
    /**
     * The UnflownPrice
     * Meta information extracted from the WSDL
     * - documentation: Sum of AirItineraryPricingInfo/TPA_Extensions/UnflownPrice
     * - minOccurs: 0
     * @var \SabreSoap\StructType\UnflownPriceType
     */
    public $UnflownPrice;
    /**
     * The eTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ETicket
     */
    public $eTicket;
    /**
     * The DataElement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DataElement
     */
    public $DataElement;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Message
     */
    public $Message;
    /**
     * The Surcharges
     * Meta information extracted from the WSDL
     * - documentation: Surcharge information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SurchargesType[]
     */
    public $Surcharges;
    /**
     * The FareComponents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareComponents
     */
    public $FareComponents;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareMessagesType
     */
    public $Messages;
    /**
     * The BaggageInformationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\BaggageInformationListType
     */
    public $BaggageInformationList;
    /**
     * The FareCalcLine
     * Meta information extracted from the WSDL
     * - documentation: Fare calculation line.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareCalcLineType
     */
    public $FareCalcLine;
    /**
     * The FareType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareType
     */
    public $FareType;
    /**
     * The AdditionalFares
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AdditionalFares[]
     */
    public $AdditionalFares;
    /**
     * The Ops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Ops
     */
    public $Ops;
    /**
     * The ItinSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ItinSource
     */
    public $ItinSource;
    /**
     * The ValueBucket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ValueBucket
     */
    public $ValueBucket;
    /**
     * The DiversitySwapper
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DiversitySwapper
     */
    public $DiversitySwapper;
    /**
     * Constructor method for TPA_Extensions
     * @uses TPA_Extensions::setBirthDate()
     * @uses TPA_Extensions::setAge()
     * @uses TPA_Extensions::setState()
     * @uses TPA_Extensions::setTotalNumber()
     * @uses TPA_Extensions::setVoluntaryChanges()
     * @uses TPA_Extensions::setFlight()
     * @uses TPA_Extensions::setRouting()
     * @uses TPA_Extensions::setDateFlexibility()
     * @uses TPA_Extensions::setSisterDestinationLocation()
     * @uses TPA_Extensions::setSisterDestinationMileage()
     * @uses TPA_Extensions::setSisterOriginLocation()
     * @uses TPA_Extensions::setSisterOriginMileage()
     * @uses TPA_Extensions::setSegmentType()
     * @uses TPA_Extensions::setAlternateTime()
     * @uses TPA_Extensions::setMaxOneWayOptions()
     * @uses TPA_Extensions::setNumOneWayOptions()
     * @uses TPA_Extensions::setCabinPref()
     * @uses TPA_Extensions::setConnectionTime()
     * @uses TPA_Extensions::setTotalTravelTime()
     * @uses TPA_Extensions::setIncludeVendorPref()
     * @uses TPA_Extensions::setIncludeAlliancePref()
     * @uses TPA_Extensions::setDepartureDays()
     * @uses TPA_Extensions::setIntelliSellTransaction()
     * @uses TPA_Extensions::setDiversityControl()
     * @uses TPA_Extensions::setMessagingDetails()
     * @uses TPA_Extensions::setAlternateAirportCities()
     * @uses TPA_Extensions::setAlternateAirportMileage()
     * @uses TPA_Extensions::setSplitTaxes()
     * @uses TPA_Extensions::setMultiTicket()
     * @uses TPA_Extensions::setPartitions()
     * @uses TPA_Extensions::setReservationData()
     * @uses TPA_Extensions::setAlternatePCC()
     * @uses TPA_Extensions::setExcludeAlliancePref()
     * @uses TPA_Extensions::setPublicFare()
     * @uses TPA_Extensions::setPrivateFare()
     * @uses TPA_Extensions::setPriority()
     * @uses TPA_Extensions::setIndicators()
     * @uses TPA_Extensions::setPromoID()
     * @uses TPA_Extensions::setCustomerType()
     * @uses TPA_Extensions::setMultipleTravelerGroups()
     * @uses TPA_Extensions::setBrandedFareIndicators()
     * @uses TPA_Extensions::setPassengerStatus()
     * @uses TPA_Extensions::setPointOfSaleOverride()
     * @uses TPA_Extensions::setPointOfTicketingOverride()
     * @uses TPA_Extensions::setOBFees()
     * @uses TPA_Extensions::setFareBreaksAtLegs()
     * @uses TPA_Extensions::setDepartureWindow()
     * @uses TPA_Extensions::setArrivalWindow()
     * @uses TPA_Extensions::setExcludeVendorPref()
     * @uses TPA_Extensions::setNumTrips()
     * @uses TPA_Extensions::setAltCitiesCombinations()
     * @uses TPA_Extensions::setNumTripsWithRouting()
     * @uses TPA_Extensions::setOnlineIndicator()
     * @uses TPA_Extensions::setInterlineIndicator()
     * @uses TPA_Extensions::setTripType()
     * @uses TPA_Extensions::setMaxPrice()
     * @uses TPA_Extensions::setDomesticLayoverTime()
     * @uses TPA_Extensions::setLongConnectTime()
     * @uses TPA_Extensions::setLongConnectPoints()
     * @uses TPA_Extensions::setAirServiceOnly()
     * @uses TPA_Extensions::setJetServiceOnly()
     * @uses TPA_Extensions::setSameConnectionAirportOnly()
     * @uses TPA_Extensions::setSameOriginAirportOnly()
     * @uses TPA_Extensions::setSameTurnaroundAirportOnly()
     * @uses TPA_Extensions::setAircraftTypePenalty()
     * @uses TPA_Extensions::setAlternateAirportPenalty()
     * @uses TPA_Extensions::setFareAmountThreshold()
     * @uses TPA_Extensions::setNumOfLowFareSol()
     * @uses TPA_Extensions::setNumOfMustPriceOnlSol()
     * @uses TPA_Extensions::setNumOfMustPriceInrlSol()
     * @uses TPA_Extensions::setNumOfMustPriceNStpOnlSol()
     * @uses TPA_Extensions::setNumOfMustPriceNStpInrlSol()
     * @uses TPA_Extensions::setNumOfMustPriceSStopOnlSol()
     * @uses TPA_Extensions::setStpPenaltyInUSD()
     * @uses TPA_Extensions::setDurPenaltyInUSD()
     * @uses TPA_Extensions::setDepPenaltyInUSD()
     * @uses TPA_Extensions::setMaxAllowedMustPriceOveragePerCrr()
     * @uses TPA_Extensions::setFltOptMustPriceReuseLimit()
     * @uses TPA_Extensions::setUpperBoundMustPriceFactorForNotNonStp()
     * @uses TPA_Extensions::setUpperBoundLFSFactor()
     * @uses TPA_Extensions::setNumOfMustPriceNStp1StpOnlSol()
     * @uses TPA_Extensions::setNumOfMustPriceNStp1StpInrlSol()
     * @uses TPA_Extensions::setUpperBoundMustPriceFactorForNonStp()
     * @uses TPA_Extensions::setMaxAllowedLFSOveragePerCrrPercent()
     * @uses TPA_Extensions::setTargetMinNumOfLFSOnlSolPerCrr()
     * @uses TPA_Extensions::setTargetMinNumOfLFSTotOnlSolPercent()
     * @uses TPA_Extensions::setFltOptLFSReuseLimitForNonAVS()
     * @uses TPA_Extensions::setFltOptLFSReuseLimitForAVS()
     * @uses TPA_Extensions::setAvsPenaltyCrrs()
     * @uses TPA_Extensions::setMaxNumOfNonStpOnlSol()
     * @uses TPA_Extensions::setMaxNumOfNonStpInrlSol()
     * @uses TPA_Extensions::setMaxNumOfSingleStpOnlSol()
     * @uses TPA_Extensions::setMaxNumOf2PlusStpSol()
     * @uses TPA_Extensions::setMinAllowedOveragePerCrrPercent()
     * @uses TPA_Extensions::setMinAllowedOveragePerCrr()
     * @uses TPA_Extensions::setMaxRelFareLvlOfxForNonStp()
     * @uses TPA_Extensions::setMaxRelFareLvlOfxForCnx()
     * @uses TPA_Extensions::setNumOfMustPrice2PlusStpSol()
     * @uses TPA_Extensions::setItineraryNumberThreshold()
     * @uses TPA_Extensions::setXOFares()
     * @uses TPA_Extensions::setExemptAllTaxes()
     * @uses TPA_Extensions::setExemptAllTaxesAndFees()
     * @uses TPA_Extensions::setTaxes()
     * @uses TPA_Extensions::setExemptTax()
     * @uses TPA_Extensions::setFlightStopsAsConnections()
     * @uses TPA_Extensions::setTicketingSumOfLocals()
     * @uses TPA_Extensions::setJumpCabinLogic()
     * @uses TPA_Extensions::setGoverningCarrierOverride()
     * @uses TPA_Extensions::setExcludeCallDirectCarriers()
     * @uses TPA_Extensions::setValidatingCarrier()
     * @uses TPA_Extensions::setSettlementMethod()
     * @uses TPA_Extensions::setFlexibleFares()
     * @uses TPA_Extensions::setDiversityParameters()
     * @uses TPA_Extensions::setAdditionalFareLimit()
     * @uses TPA_Extensions::setOptionsPerDatePairList()
     * @uses TPA_Extensions::setProcessingMessage()
     * @uses TPA_Extensions::setAirlineOrderList()
     * @uses TPA_Extensions::setSeatsRemaining()
     * @uses TPA_Extensions::setCabin()
     * @uses TPA_Extensions::setFareNote()
     * @uses TPA_Extensions::setMeal()
     * @uses TPA_Extensions::setRule()
     * @uses TPA_Extensions::setDivideInParty()
     * @uses TPA_Extensions::setPromoOffer()
     * @uses TPA_Extensions::setPromoRedemption()
     * @uses TPA_Extensions::setAncillaryFeeGroups()
     * @uses TPA_Extensions::setLegs()
     * @uses TPA_Extensions::setUnflownPrice()
     * @uses TPA_Extensions::setETicket()
     * @uses TPA_Extensions::setDataElement()
     * @uses TPA_Extensions::setMessage()
     * @uses TPA_Extensions::setSurcharges()
     * @uses TPA_Extensions::setFareComponents()
     * @uses TPA_Extensions::setMessages()
     * @uses TPA_Extensions::setBaggageInformationList()
     * @uses TPA_Extensions::setFareCalcLine()
     * @uses TPA_Extensions::setFareType()
     * @uses TPA_Extensions::setAdditionalFares()
     * @uses TPA_Extensions::setOps()
     * @uses TPA_Extensions::setItinSource()
     * @uses TPA_Extensions::setValueBucket()
     * @uses TPA_Extensions::setDiversitySwapper()
     * @param \SabreSoap\StructType\BirthDate $birthDate
     * @param \SabreSoap\StructType\Age $age
     * @param \SabreSoap\StructType\State $state
     * @param \SabreSoap\StructType\TotalNumber $totalNumber
     * @param \SabreSoap\StructType\VoluntaryChanges $voluntaryChanges
     * @param \SabreSoap\StructType\OriginDestinationFlightType[] $flight
     * @param \SabreSoap\StructType\RoutingDefinitionType[] $routing
     * @param \SabreSoap\StructType\DateFlexibility $dateFlexibility
     * @param \SabreSoap\StructType\RequestLocationType $sisterDestinationLocation
     * @param \SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage
     * @param \SabreSoap\StructType\RequestLocationType $sisterOriginLocation
     * @param \SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage
     * @param \SabreSoap\StructType\SegmentType $segmentType
     * @param \SabreSoap\StructType\AlternateTime $alternateTime
     * @param \SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions
     * @param \SabreSoap\StructType\NumOneWayOptions $numOneWayOptions
     * @param \SabreSoap\StructType\CabinPrefType $cabinPref
     * @param \SabreSoap\StructType\ConnectionTime $connectionTime
     * @param \SabreSoap\StructType\TotalTravelTime $totalTravelTime
     * @param \SabreSoap\StructType\IncludeVendorPrefType[] $includeVendorPref
     * @param \SabreSoap\StructType\AllianceType[] $includeAlliancePref
     * @param \SabreSoap\StructType\DepartureDaysType $departureDays
     * @param \SabreSoap\StructType\TransactionType $intelliSellTransaction
     * @param \SabreSoap\StructType\DiversityControlType $diversityControl
     * @param \SabreSoap\StructType\MessagingDetails $messagingDetails
     * @param \SabreSoap\StructType\AlternateAirportCities[] $alternateAirportCities
     * @param \SabreSoap\StructType\AlternateAirportMileage $alternateAirportMileage
     * @param \SabreSoap\StructType\SplitTaxes $splitTaxes
     * @param \SabreSoap\StructType\MultiTicket $multiTicket
     * @param \SabreSoap\StructType\Partitions $partitions
     * @param \SabreSoap\StructType\ReservationData $reservationData
     * @param \SabreSoap\StructType\AlternatePCC[] $alternatePCC
     * @param \SabreSoap\StructType\AllianceType[] $excludeAlliancePref
     * @param \SabreSoap\StructType\PublicFare $publicFare
     * @param \SabreSoap\StructType\PrivateFare $privateFare
     * @param \SabreSoap\StructType\Priority $priority
     * @param \SabreSoap\StructType\Indicators $indicators
     * @param string $promoID
     * @param \SabreSoap\StructType\CustomerType $customerType
     * @param \SabreSoap\StructType\MultipleTravelerGroups $multipleTravelerGroups
     * @param \SabreSoap\StructType\BrandedFareIndicators $brandedFareIndicators
     * @param \SabreSoap\StructType\PassengerStatus $passengerStatus
     * @param \SabreSoap\StructType\PointOfSaleOverrideType $pointOfSaleOverride
     * @param \SabreSoap\StructType\PointOfTicketingOverrideType $pointOfTicketingOverride
     * @param \SabreSoap\StructType\OBFees $oBFees
     * @param \SabreSoap\StructType\FareBreaksAtLegs $fareBreaksAtLegs
     * @param string $departureWindow
     * @param string $arrivalWindow
     * @param \SabreSoap\StructType\ExcludeVendorPref[] $excludeVendorPref
     * @param \SabreSoap\StructType\NumTripsType $numTrips
     * @param \SabreSoap\StructType\AltCitiesCombinationsType $altCitiesCombinations
     * @param \SabreSoap\StructType\NumTripsWithRouting $numTripsWithRouting
     * @param \SabreSoap\StructType\OnlineIndicator $onlineIndicator
     * @param \SabreSoap\StructType\InterlineIndicator $interlineIndicator
     * @param \SabreSoap\StructType\TripType $tripType
     * @param \SabreSoap\StructType\MaxPrice $maxPrice
     * @param \SabreSoap\StructType\DomesticLayoverTime $domesticLayoverTime
     * @param \SabreSoap\StructType\LongConnectTime $longConnectTime
     * @param \SabreSoap\StructType\LongConnectPoints $longConnectPoints
     * @param \SabreSoap\StructType\AirServiceOnly $airServiceOnly
     * @param \SabreSoap\StructType\JetServiceOnly $jetServiceOnly
     * @param \SabreSoap\StructType\SameConnectionAirportOnly $sameConnectionAirportOnly
     * @param \SabreSoap\StructType\SameOriginAirportOnly $sameOriginAirportOnly
     * @param \SabreSoap\StructType\SameTurnaroundAirportOnly $sameTurnaroundAirportOnly
     * @param \SabreSoap\StructType\AircraftTypePenalty $aircraftTypePenalty
     * @param \SabreSoap\StructType\AlternateAirportPenalty $alternateAirportPenalty
     * @param \SabreSoap\StructType\FareAmountThreshold $fareAmountThreshold
     * @param \SabreSoap\StructType\NumOfLowFareSol $numOfLowFareSol
     * @param \SabreSoap\StructType\NumOfMustPriceOnlSol $numOfMustPriceOnlSol
     * @param \SabreSoap\StructType\NumOfMustPriceInrlSol $numOfMustPriceInrlSol
     * @param \SabreSoap\StructType\NumOfMustPriceNStpOnlSol $numOfMustPriceNStpOnlSol
     * @param \SabreSoap\StructType\NumOfMustPriceNStpInrlSol $numOfMustPriceNStpInrlSol
     * @param \SabreSoap\StructType\NumOfMustPriceSStopOnlSol $numOfMustPriceSStopOnlSol
     * @param \SabreSoap\StructType\StpPenaltyInUSD $stpPenaltyInUSD
     * @param \SabreSoap\StructType\DurPenaltyInUSD $durPenaltyInUSD
     * @param \SabreSoap\StructType\DepPenaltyInUSD $depPenaltyInUSD
     * @param \SabreSoap\StructType\MaxAllowedMustPriceOveragePerCrr $maxAllowedMustPriceOveragePerCrr
     * @param \SabreSoap\StructType\FltOptMustPriceReuseLimit $fltOptMustPriceReuseLimit
     * @param \SabreSoap\StructType\UpperBoundMustPriceFactorForNotNonStp $upperBoundMustPriceFactorForNotNonStp
     * @param \SabreSoap\StructType\UpperBoundLFSFactor $upperBoundLFSFactor
     * @param \SabreSoap\StructType\NumOfMustPriceNStp1StpOnlSol $numOfMustPriceNStp1StpOnlSol
     * @param \SabreSoap\StructType\NumOfMustPriceNStp1StpInrlSol $numOfMustPriceNStp1StpInrlSol
     * @param \SabreSoap\StructType\UpperBoundMustPriceFactorForNonStp $upperBoundMustPriceFactorForNonStp
     * @param \SabreSoap\StructType\MaxAllowedLFSOveragePerCrrPercent $maxAllowedLFSOveragePerCrrPercent
     * @param \SabreSoap\StructType\TargetMinNumOfLFSOnlSolPerCrr $targetMinNumOfLFSOnlSolPerCrr
     * @param \SabreSoap\StructType\TargetMinNumOfLFSTotOnlSolPercent $targetMinNumOfLFSTotOnlSolPercent
     * @param \SabreSoap\StructType\FltOptLFSReuseLimitForNonAVS $fltOptLFSReuseLimitForNonAVS
     * @param \SabreSoap\StructType\FltOptLFSReuseLimitForAVS $fltOptLFSReuseLimitForAVS
     * @param \SabreSoap\StructType\AvsPenaltyCrrs $avsPenaltyCrrs
     * @param \SabreSoap\StructType\MaxNumOfNonStpOnlSol $maxNumOfNonStpOnlSol
     * @param \SabreSoap\StructType\MaxNumOfNonStpInrlSol $maxNumOfNonStpInrlSol
     * @param \SabreSoap\StructType\MaxNumOfSingleStpOnlSol $maxNumOfSingleStpOnlSol
     * @param \SabreSoap\StructType\MaxNumOf2PlusStpSol $maxNumOf2PlusStpSol
     * @param \SabreSoap\StructType\MinAllowedOveragePerCrrPercent $minAllowedOveragePerCrrPercent
     * @param \SabreSoap\StructType\MinAllowedOveragePerCrr $minAllowedOveragePerCrr
     * @param \SabreSoap\StructType\MaxRelFareLvlOfxForNonStp $maxRelFareLvlOfxForNonStp
     * @param \SabreSoap\StructType\MaxRelFareLvlOfxForCnx $maxRelFareLvlOfxForCnx
     * @param \SabreSoap\StructType\NumOfMustPrice2PlusStpSol $numOfMustPrice2PlusStpSol
     * @param \SabreSoap\StructType\ItineraryNumberThreshold $itineraryNumberThreshold
     * @param \SabreSoap\StructType\XOFaresType $xOFares
     * @param \SabreSoap\StructType\ExemptAllTaxes $exemptAllTaxes
     * @param \SabreSoap\StructType\ExemptAllTaxesAndFees $exemptAllTaxesAndFees
     * @param \SabreSoap\StructType\Taxes $taxes
     * @param \SabreSoap\StructType\TaxCodeType $exemptTax
     * @param \SabreSoap\StructType\FlightStopsAsConnectionsType $flightStopsAsConnections
     * @param \SabreSoap\StructType\TicketingSumOfLocals $ticketingSumOfLocals
     * @param \SabreSoap\StructType\JumpCabinLogicType $jumpCabinLogic
     * @param \SabreSoap\StructType\GoverningCarrierOverrideType $governingCarrierOverride
     * @param \SabreSoap\StructType\ExcludeCallDirectCarriers $excludeCallDirectCarriers
     * @param \SabreSoap\StructType\ValidatingCarrierType $validatingCarrier
     * @param string $settlementMethod
     * @param \SabreSoap\StructType\FlexibleFaresType $flexibleFares
     * @param \SabreSoap\StructType\DiversityParameters $diversityParameters
     * @param \SabreSoap\StructType\AdditionalFareLimit $additionalFareLimit
     * @param \SabreSoap\StructType\OptionsPerDatePairList $optionsPerDatePairList
     * @param \SabreSoap\StructType\ComplexProcessingMessageType[] $processingMessage
     * @param \SabreSoap\StructType\AirlineOrderList $airlineOrderList
     * @param \SabreSoap\StructType\SeatsRemaining $seatsRemaining
     * @param \SabreSoap\StructType\Cabin $cabin
     * @param \SabreSoap\StructType\FareNote[] $fareNote
     * @param \SabreSoap\StructType\Meal $meal
     * @param \SabreSoap\StructType\Rule[] $rule
     * @param \SabreSoap\StructType\DivideInParty $divideInParty
     * @param \SabreSoap\StructType\PromoOffer $promoOffer
     * @param \SabreSoap\StructType\PromoRedemption $promoRedemption
     * @param \SabreSoap\StructType\AncillaryFeeGroups $ancillaryFeeGroups
     * @param \SabreSoap\StructType\Legs $legs
     * @param \SabreSoap\StructType\UnflownPriceType $unflownPrice
     * @param \SabreSoap\StructType\ETicket $eTicket
     * @param \SabreSoap\StructType\DataElement $dataElement
     * @param \SabreSoap\StructType\Message $message
     * @param \SabreSoap\StructType\SurchargesType[] $surcharges
     * @param \SabreSoap\StructType\FareComponents $fareComponents
     * @param \SabreSoap\StructType\FareMessagesType $messages
     * @param \SabreSoap\StructType\BaggageInformationListType $baggageInformationList
     * @param \SabreSoap\StructType\FareCalcLineType $fareCalcLine
     * @param \SabreSoap\StructType\FareType $fareType
     * @param \SabreSoap\StructType\AdditionalFares[] $additionalFares
     * @param \SabreSoap\StructType\Ops $ops
     * @param \SabreSoap\StructType\ItinSource $itinSource
     * @param \SabreSoap\StructType\ValueBucket $valueBucket
     * @param \SabreSoap\StructType\DiversitySwapper $diversitySwapper
     */
    public function __construct(\SabreSoap\StructType\BirthDate $birthDate = null, \SabreSoap\StructType\Age $age = null, \SabreSoap\StructType\State $state = null, \SabreSoap\StructType\TotalNumber $totalNumber = null, \SabreSoap\StructType\VoluntaryChanges $voluntaryChanges = null, array $flight = array(), array $routing = array(), \SabreSoap\StructType\DateFlexibility $dateFlexibility = null, \SabreSoap\StructType\RequestLocationType $sisterDestinationLocation = null, \SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage = null, \SabreSoap\StructType\RequestLocationType $sisterOriginLocation = null, \SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage = null, \SabreSoap\StructType\SegmentType $segmentType = null, \SabreSoap\StructType\AlternateTime $alternateTime = null, \SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions = null, \SabreSoap\StructType\NumOneWayOptions $numOneWayOptions = null, \SabreSoap\StructType\CabinPrefType $cabinPref = null, \SabreSoap\StructType\ConnectionTime $connectionTime = null, \SabreSoap\StructType\TotalTravelTime $totalTravelTime = null, array $includeVendorPref = array(), array $includeAlliancePref = array(), \SabreSoap\StructType\DepartureDaysType $departureDays = null, \SabreSoap\StructType\TransactionType $intelliSellTransaction = null, \SabreSoap\StructType\DiversityControlType $diversityControl = null, \SabreSoap\StructType\MessagingDetails $messagingDetails = null, array $alternateAirportCities = array(), \SabreSoap\StructType\AlternateAirportMileage $alternateAirportMileage = null, \SabreSoap\StructType\SplitTaxes $splitTaxes = null, \SabreSoap\StructType\MultiTicket $multiTicket = null, \SabreSoap\StructType\Partitions $partitions = null, \SabreSoap\StructType\ReservationData $reservationData = null, array $alternatePCC = array(), array $excludeAlliancePref = array(), \SabreSoap\StructType\PublicFare $publicFare = null, \SabreSoap\StructType\PrivateFare $privateFare = null, \SabreSoap\StructType\Priority $priority = null, \SabreSoap\StructType\Indicators $indicators = null, $promoID = null, \SabreSoap\StructType\CustomerType $customerType = null, \SabreSoap\StructType\MultipleTravelerGroups $multipleTravelerGroups = null, \SabreSoap\StructType\BrandedFareIndicators $brandedFareIndicators = null, \SabreSoap\StructType\PassengerStatus $passengerStatus = null, \SabreSoap\StructType\PointOfSaleOverrideType $pointOfSaleOverride = null, \SabreSoap\StructType\PointOfTicketingOverrideType $pointOfTicketingOverride = null, \SabreSoap\StructType\OBFees $oBFees = null, \SabreSoap\StructType\FareBreaksAtLegs $fareBreaksAtLegs = null, $departureWindow = null, $arrivalWindow = null, array $excludeVendorPref = array(), \SabreSoap\StructType\NumTripsType $numTrips = null, \SabreSoap\StructType\AltCitiesCombinationsType $altCitiesCombinations = null, \SabreSoap\StructType\NumTripsWithRouting $numTripsWithRouting = null, \SabreSoap\StructType\OnlineIndicator $onlineIndicator = null, \SabreSoap\StructType\InterlineIndicator $interlineIndicator = null, \SabreSoap\StructType\TripType $tripType = null, \SabreSoap\StructType\MaxPrice $maxPrice = null, \SabreSoap\StructType\DomesticLayoverTime $domesticLayoverTime = null, \SabreSoap\StructType\LongConnectTime $longConnectTime = null, \SabreSoap\StructType\LongConnectPoints $longConnectPoints = null, \SabreSoap\StructType\AirServiceOnly $airServiceOnly = null, \SabreSoap\StructType\JetServiceOnly $jetServiceOnly = null, \SabreSoap\StructType\SameConnectionAirportOnly $sameConnectionAirportOnly = null, \SabreSoap\StructType\SameOriginAirportOnly $sameOriginAirportOnly = null, \SabreSoap\StructType\SameTurnaroundAirportOnly $sameTurnaroundAirportOnly = null, \SabreSoap\StructType\AircraftTypePenalty $aircraftTypePenalty = null, \SabreSoap\StructType\AlternateAirportPenalty $alternateAirportPenalty = null, \SabreSoap\StructType\FareAmountThreshold $fareAmountThreshold = null, \SabreSoap\StructType\NumOfLowFareSol $numOfLowFareSol = null, \SabreSoap\StructType\NumOfMustPriceOnlSol $numOfMustPriceOnlSol = null, \SabreSoap\StructType\NumOfMustPriceInrlSol $numOfMustPriceInrlSol = null, \SabreSoap\StructType\NumOfMustPriceNStpOnlSol $numOfMustPriceNStpOnlSol = null, \SabreSoap\StructType\NumOfMustPriceNStpInrlSol $numOfMustPriceNStpInrlSol = null, \SabreSoap\StructType\NumOfMustPriceSStopOnlSol $numOfMustPriceSStopOnlSol = null, \SabreSoap\StructType\StpPenaltyInUSD $stpPenaltyInUSD = null, \SabreSoap\StructType\DurPenaltyInUSD $durPenaltyInUSD = null, \SabreSoap\StructType\DepPenaltyInUSD $depPenaltyInUSD = null, \SabreSoap\StructType\MaxAllowedMustPriceOveragePerCrr $maxAllowedMustPriceOveragePerCrr = null, \SabreSoap\StructType\FltOptMustPriceReuseLimit $fltOptMustPriceReuseLimit = null, \SabreSoap\StructType\UpperBoundMustPriceFactorForNotNonStp $upperBoundMustPriceFactorForNotNonStp = null, \SabreSoap\StructType\UpperBoundLFSFactor $upperBoundLFSFactor = null, \SabreSoap\StructType\NumOfMustPriceNStp1StpOnlSol $numOfMustPriceNStp1StpOnlSol = null, \SabreSoap\StructType\NumOfMustPriceNStp1StpInrlSol $numOfMustPriceNStp1StpInrlSol = null, \SabreSoap\StructType\UpperBoundMustPriceFactorForNonStp $upperBoundMustPriceFactorForNonStp = null, \SabreSoap\StructType\MaxAllowedLFSOveragePerCrrPercent $maxAllowedLFSOveragePerCrrPercent = null, \SabreSoap\StructType\TargetMinNumOfLFSOnlSolPerCrr $targetMinNumOfLFSOnlSolPerCrr = null, \SabreSoap\StructType\TargetMinNumOfLFSTotOnlSolPercent $targetMinNumOfLFSTotOnlSolPercent = null, \SabreSoap\StructType\FltOptLFSReuseLimitForNonAVS $fltOptLFSReuseLimitForNonAVS = null, \SabreSoap\StructType\FltOptLFSReuseLimitForAVS $fltOptLFSReuseLimitForAVS = null, \SabreSoap\StructType\AvsPenaltyCrrs $avsPenaltyCrrs = null, \SabreSoap\StructType\MaxNumOfNonStpOnlSol $maxNumOfNonStpOnlSol = null, \SabreSoap\StructType\MaxNumOfNonStpInrlSol $maxNumOfNonStpInrlSol = null, \SabreSoap\StructType\MaxNumOfSingleStpOnlSol $maxNumOfSingleStpOnlSol = null, \SabreSoap\StructType\MaxNumOf2PlusStpSol $maxNumOf2PlusStpSol = null, \SabreSoap\StructType\MinAllowedOveragePerCrrPercent $minAllowedOveragePerCrrPercent = null, \SabreSoap\StructType\MinAllowedOveragePerCrr $minAllowedOveragePerCrr = null, \SabreSoap\StructType\MaxRelFareLvlOfxForNonStp $maxRelFareLvlOfxForNonStp = null, \SabreSoap\StructType\MaxRelFareLvlOfxForCnx $maxRelFareLvlOfxForCnx = null, \SabreSoap\StructType\NumOfMustPrice2PlusStpSol $numOfMustPrice2PlusStpSol = null, \SabreSoap\StructType\ItineraryNumberThreshold $itineraryNumberThreshold = null, \SabreSoap\StructType\XOFaresType $xOFares = null, \SabreSoap\StructType\ExemptAllTaxes $exemptAllTaxes = null, \SabreSoap\StructType\ExemptAllTaxesAndFees $exemptAllTaxesAndFees = null, \SabreSoap\StructType\Taxes $taxes = null, \SabreSoap\StructType\TaxCodeType $exemptTax = null, \SabreSoap\StructType\FlightStopsAsConnectionsType $flightStopsAsConnections = null, \SabreSoap\StructType\TicketingSumOfLocals $ticketingSumOfLocals = null, \SabreSoap\StructType\JumpCabinLogicType $jumpCabinLogic = null, \SabreSoap\StructType\GoverningCarrierOverrideType $governingCarrierOverride = null, \SabreSoap\StructType\ExcludeCallDirectCarriers $excludeCallDirectCarriers = null, \SabreSoap\StructType\ValidatingCarrierType $validatingCarrier = null, $settlementMethod = null, \SabreSoap\StructType\FlexibleFaresType $flexibleFares = null, \SabreSoap\StructType\DiversityParameters $diversityParameters = null, \SabreSoap\StructType\AdditionalFareLimit $additionalFareLimit = null, \SabreSoap\StructType\OptionsPerDatePairList $optionsPerDatePairList = null, array $processingMessage = array(), \SabreSoap\StructType\AirlineOrderList $airlineOrderList = null, \SabreSoap\StructType\SeatsRemaining $seatsRemaining = null, \SabreSoap\StructType\Cabin $cabin = null, array $fareNote = array(), \SabreSoap\StructType\Meal $meal = null, array $rule = array(), \SabreSoap\StructType\DivideInParty $divideInParty = null, \SabreSoap\StructType\PromoOffer $promoOffer = null, \SabreSoap\StructType\PromoRedemption $promoRedemption = null, \SabreSoap\StructType\AncillaryFeeGroups $ancillaryFeeGroups = null, \SabreSoap\StructType\Legs $legs = null, \SabreSoap\StructType\UnflownPriceType $unflownPrice = null, \SabreSoap\StructType\ETicket $eTicket = null, \SabreSoap\StructType\DataElement $dataElement = null, \SabreSoap\StructType\Message $message = null, array $surcharges = array(), \SabreSoap\StructType\FareComponents $fareComponents = null, \SabreSoap\StructType\FareMessagesType $messages = null, \SabreSoap\StructType\BaggageInformationListType $baggageInformationList = null, \SabreSoap\StructType\FareCalcLineType $fareCalcLine = null, \SabreSoap\StructType\FareType $fareType = null, array $additionalFares = array(), \SabreSoap\StructType\Ops $ops = null, \SabreSoap\StructType\ItinSource $itinSource = null, \SabreSoap\StructType\ValueBucket $valueBucket = null, \SabreSoap\StructType\DiversitySwapper $diversitySwapper = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setAge($age)
            ->setState($state)
            ->setTotalNumber($totalNumber)
            ->setVoluntaryChanges($voluntaryChanges)
            ->setFlight($flight)
            ->setRouting($routing)
            ->setDateFlexibility($dateFlexibility)
            ->setSisterDestinationLocation($sisterDestinationLocation)
            ->setSisterDestinationMileage($sisterDestinationMileage)
            ->setSisterOriginLocation($sisterOriginLocation)
            ->setSisterOriginMileage($sisterOriginMileage)
            ->setSegmentType($segmentType)
            ->setAlternateTime($alternateTime)
            ->setMaxOneWayOptions($maxOneWayOptions)
            ->setNumOneWayOptions($numOneWayOptions)
            ->setCabinPref($cabinPref)
            ->setConnectionTime($connectionTime)
            ->setTotalTravelTime($totalTravelTime)
            ->setIncludeVendorPref($includeVendorPref)
            ->setIncludeAlliancePref($includeAlliancePref)
            ->setDepartureDays($departureDays)
            ->setIntelliSellTransaction($intelliSellTransaction)
            ->setDiversityControl($diversityControl)
            ->setMessagingDetails($messagingDetails)
            ->setAlternateAirportCities($alternateAirportCities)
            ->setAlternateAirportMileage($alternateAirportMileage)
            ->setSplitTaxes($splitTaxes)
            ->setMultiTicket($multiTicket)
            ->setPartitions($partitions)
            ->setReservationData($reservationData)
            ->setAlternatePCC($alternatePCC)
            ->setExcludeAlliancePref($excludeAlliancePref)
            ->setPublicFare($publicFare)
            ->setPrivateFare($privateFare)
            ->setPriority($priority)
            ->setIndicators($indicators)
            ->setPromoID($promoID)
            ->setCustomerType($customerType)
            ->setMultipleTravelerGroups($multipleTravelerGroups)
            ->setBrandedFareIndicators($brandedFareIndicators)
            ->setPassengerStatus($passengerStatus)
            ->setPointOfSaleOverride($pointOfSaleOverride)
            ->setPointOfTicketingOverride($pointOfTicketingOverride)
            ->setOBFees($oBFees)
            ->setFareBreaksAtLegs($fareBreaksAtLegs)
            ->setDepartureWindow($departureWindow)
            ->setArrivalWindow($arrivalWindow)
            ->setExcludeVendorPref($excludeVendorPref)
            ->setNumTrips($numTrips)
            ->setAltCitiesCombinations($altCitiesCombinations)
            ->setNumTripsWithRouting($numTripsWithRouting)
            ->setOnlineIndicator($onlineIndicator)
            ->setInterlineIndicator($interlineIndicator)
            ->setTripType($tripType)
            ->setMaxPrice($maxPrice)
            ->setDomesticLayoverTime($domesticLayoverTime)
            ->setLongConnectTime($longConnectTime)
            ->setLongConnectPoints($longConnectPoints)
            ->setAirServiceOnly($airServiceOnly)
            ->setJetServiceOnly($jetServiceOnly)
            ->setSameConnectionAirportOnly($sameConnectionAirportOnly)
            ->setSameOriginAirportOnly($sameOriginAirportOnly)
            ->setSameTurnaroundAirportOnly($sameTurnaroundAirportOnly)
            ->setAircraftTypePenalty($aircraftTypePenalty)
            ->setAlternateAirportPenalty($alternateAirportPenalty)
            ->setFareAmountThreshold($fareAmountThreshold)
            ->setNumOfLowFareSol($numOfLowFareSol)
            ->setNumOfMustPriceOnlSol($numOfMustPriceOnlSol)
            ->setNumOfMustPriceInrlSol($numOfMustPriceInrlSol)
            ->setNumOfMustPriceNStpOnlSol($numOfMustPriceNStpOnlSol)
            ->setNumOfMustPriceNStpInrlSol($numOfMustPriceNStpInrlSol)
            ->setNumOfMustPriceSStopOnlSol($numOfMustPriceSStopOnlSol)
            ->setStpPenaltyInUSD($stpPenaltyInUSD)
            ->setDurPenaltyInUSD($durPenaltyInUSD)
            ->setDepPenaltyInUSD($depPenaltyInUSD)
            ->setMaxAllowedMustPriceOveragePerCrr($maxAllowedMustPriceOveragePerCrr)
            ->setFltOptMustPriceReuseLimit($fltOptMustPriceReuseLimit)
            ->setUpperBoundMustPriceFactorForNotNonStp($upperBoundMustPriceFactorForNotNonStp)
            ->setUpperBoundLFSFactor($upperBoundLFSFactor)
            ->setNumOfMustPriceNStp1StpOnlSol($numOfMustPriceNStp1StpOnlSol)
            ->setNumOfMustPriceNStp1StpInrlSol($numOfMustPriceNStp1StpInrlSol)
            ->setUpperBoundMustPriceFactorForNonStp($upperBoundMustPriceFactorForNonStp)
            ->setMaxAllowedLFSOveragePerCrrPercent($maxAllowedLFSOveragePerCrrPercent)
            ->setTargetMinNumOfLFSOnlSolPerCrr($targetMinNumOfLFSOnlSolPerCrr)
            ->setTargetMinNumOfLFSTotOnlSolPercent($targetMinNumOfLFSTotOnlSolPercent)
            ->setFltOptLFSReuseLimitForNonAVS($fltOptLFSReuseLimitForNonAVS)
            ->setFltOptLFSReuseLimitForAVS($fltOptLFSReuseLimitForAVS)
            ->setAvsPenaltyCrrs($avsPenaltyCrrs)
            ->setMaxNumOfNonStpOnlSol($maxNumOfNonStpOnlSol)
            ->setMaxNumOfNonStpInrlSol($maxNumOfNonStpInrlSol)
            ->setMaxNumOfSingleStpOnlSol($maxNumOfSingleStpOnlSol)
            ->setMaxNumOf2PlusStpSol($maxNumOf2PlusStpSol)
            ->setMinAllowedOveragePerCrrPercent($minAllowedOveragePerCrrPercent)
            ->setMinAllowedOveragePerCrr($minAllowedOveragePerCrr)
            ->setMaxRelFareLvlOfxForNonStp($maxRelFareLvlOfxForNonStp)
            ->setMaxRelFareLvlOfxForCnx($maxRelFareLvlOfxForCnx)
            ->setNumOfMustPrice2PlusStpSol($numOfMustPrice2PlusStpSol)
            ->setItineraryNumberThreshold($itineraryNumberThreshold)
            ->setXOFares($xOFares)
            ->setExemptAllTaxes($exemptAllTaxes)
            ->setExemptAllTaxesAndFees($exemptAllTaxesAndFees)
            ->setTaxes($taxes)
            ->setExemptTax($exemptTax)
            ->setFlightStopsAsConnections($flightStopsAsConnections)
            ->setTicketingSumOfLocals($ticketingSumOfLocals)
            ->setJumpCabinLogic($jumpCabinLogic)
            ->setGoverningCarrierOverride($governingCarrierOverride)
            ->setExcludeCallDirectCarriers($excludeCallDirectCarriers)
            ->setValidatingCarrier($validatingCarrier)
            ->setSettlementMethod($settlementMethod)
            ->setFlexibleFares($flexibleFares)
            ->setDiversityParameters($diversityParameters)
            ->setAdditionalFareLimit($additionalFareLimit)
            ->setOptionsPerDatePairList($optionsPerDatePairList)
            ->setProcessingMessage($processingMessage)
            ->setAirlineOrderList($airlineOrderList)
            ->setSeatsRemaining($seatsRemaining)
            ->setCabin($cabin)
            ->setFareNote($fareNote)
            ->setMeal($meal)
            ->setRule($rule)
            ->setDivideInParty($divideInParty)
            ->setPromoOffer($promoOffer)
            ->setPromoRedemption($promoRedemption)
            ->setAncillaryFeeGroups($ancillaryFeeGroups)
            ->setLegs($legs)
            ->setUnflownPrice($unflownPrice)
            ->setETicket($eTicket)
            ->setDataElement($dataElement)
            ->setMessage($message)
            ->setSurcharges($surcharges)
            ->setFareComponents($fareComponents)
            ->setMessages($messages)
            ->setBaggageInformationList($baggageInformationList)
            ->setFareCalcLine($fareCalcLine)
            ->setFareType($fareType)
            ->setAdditionalFares($additionalFares)
            ->setOps($ops)
            ->setItinSource($itinSource)
            ->setValueBucket($valueBucket)
            ->setDiversitySwapper($diversitySwapper);
    }
    /**
     * Get BirthDate value
     * @return \SabreSoap\StructType\BirthDate|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param \SabreSoap\StructType\BirthDate $birthDate
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setBirthDate(\SabreSoap\StructType\BirthDate $birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Age value
     * @return \SabreSoap\StructType\Age|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param \SabreSoap\StructType\Age $age
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAge(\SabreSoap\StructType\Age $age = null)
    {
        $this->Age = $age;
        return $this;
    }
    /**
     * Get State value
     * @return \SabreSoap\StructType\State|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param \SabreSoap\StructType\State $state
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setState(\SabreSoap\StructType\State $state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get TotalNumber value
     * @return \SabreSoap\StructType\TotalNumber|null
     */
    public function getTotalNumber()
    {
        return $this->TotalNumber;
    }
    /**
     * Set TotalNumber value
     * @param \SabreSoap\StructType\TotalNumber $totalNumber
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setTotalNumber(\SabreSoap\StructType\TotalNumber $totalNumber = null)
    {
        $this->TotalNumber = $totalNumber;
        return $this;
    }
    /**
     * Get VoluntaryChanges value
     * @return \SabreSoap\StructType\VoluntaryChanges|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param \SabreSoap\StructType\VoluntaryChanges $voluntaryChanges
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setVoluntaryChanges(\SabreSoap\StructType\VoluntaryChanges $voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
    /**
     * Get Flight value
     * @return \SabreSoap\StructType\OriginDestinationFlightType[]|null
     */
    public function getFlight()
    {
        return $this->Flight;
    }
    /**
     * Set Flight value
     * @param \SabreSoap\StructType\OriginDestinationFlightType[] $flight
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFlight(array $flight = array())
    {
        $this->Flight = $flight;
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\OriginDestinationFlightType $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToFlight(\SabreSoap\StructType\OriginDestinationFlightType $item)
    {
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Get Routing value
     * @return \SabreSoap\StructType\RoutingDefinitionType[]|null
     */
    public function getRouting()
    {
        return $this->Routing;
    }
    /**
     * Set Routing value
     * @param \SabreSoap\StructType\RoutingDefinitionType[] $routing
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setRouting(array $routing = array())
    {
        $this->Routing = $routing;
        return $this;
    }
    /**
     * Add item to Routing value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\RoutingDefinitionType $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToRouting(\SabreSoap\StructType\RoutingDefinitionType $item)
    {
        $this->Routing[] = $item;
        return $this;
    }
    /**
     * Get DateFlexibility value
     * @return \SabreSoap\StructType\DateFlexibility|null
     */
    public function getDateFlexibility()
    {
        return $this->DateFlexibility;
    }
    /**
     * Set DateFlexibility value
     * @param \SabreSoap\StructType\DateFlexibility $dateFlexibility
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDateFlexibility(\SabreSoap\StructType\DateFlexibility $dateFlexibility = null)
    {
        $this->DateFlexibility = $dateFlexibility;
        return $this;
    }
    /**
     * Get SisterDestinationLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getSisterDestinationLocation()
    {
        return $this->SisterDestinationLocation;
    }
    /**
     * Set SisterDestinationLocation value
     * @param \SabreSoap\StructType\RequestLocationType $sisterDestinationLocation
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSisterDestinationLocation(\SabreSoap\StructType\RequestLocationType $sisterDestinationLocation = null)
    {
        $this->SisterDestinationLocation = $sisterDestinationLocation;
        return $this;
    }
    /**
     * Get SisterDestinationMileage value
     * @return \SabreSoap\StructType\SisterDestinationMileage|null
     */
    public function getSisterDestinationMileage()
    {
        return $this->SisterDestinationMileage;
    }
    /**
     * Set SisterDestinationMileage value
     * @param \SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSisterDestinationMileage(\SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage = null)
    {
        $this->SisterDestinationMileage = $sisterDestinationMileage;
        return $this;
    }
    /**
     * Get SisterOriginLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getSisterOriginLocation()
    {
        return $this->SisterOriginLocation;
    }
    /**
     * Set SisterOriginLocation value
     * @param \SabreSoap\StructType\RequestLocationType $sisterOriginLocation
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSisterOriginLocation(\SabreSoap\StructType\RequestLocationType $sisterOriginLocation = null)
    {
        $this->SisterOriginLocation = $sisterOriginLocation;
        return $this;
    }
    /**
     * Get SisterOriginMileage value
     * @return \SabreSoap\StructType\SisterOriginMileage|null
     */
    public function getSisterOriginMileage()
    {
        return $this->SisterOriginMileage;
    }
    /**
     * Set SisterOriginMileage value
     * @param \SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSisterOriginMileage(\SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage = null)
    {
        $this->SisterOriginMileage = $sisterOriginMileage;
        return $this;
    }
    /**
     * Get SegmentType value
     * @return \SabreSoap\StructType\SegmentType|null
     */
    public function getSegmentType()
    {
        return $this->SegmentType;
    }
    /**
     * Set SegmentType value
     * @param \SabreSoap\StructType\SegmentType $segmentType
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSegmentType(\SabreSoap\StructType\SegmentType $segmentType = null)
    {
        $this->SegmentType = $segmentType;
        return $this;
    }
    /**
     * Get AlternateTime value
     * @return \SabreSoap\StructType\AlternateTime|null
     */
    public function getAlternateTime()
    {
        return $this->AlternateTime;
    }
    /**
     * Set AlternateTime value
     * @param \SabreSoap\StructType\AlternateTime $alternateTime
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAlternateTime(\SabreSoap\StructType\AlternateTime $alternateTime = null)
    {
        $this->AlternateTime = $alternateTime;
        return $this;
    }
    /**
     * Get MaxOneWayOptions value
     * @return \SabreSoap\StructType\MaxOneWayOptions|null
     */
    public function getMaxOneWayOptions()
    {
        return $this->MaxOneWayOptions;
    }
    /**
     * Set MaxOneWayOptions value
     * @param \SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxOneWayOptions(\SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions = null)
    {
        $this->MaxOneWayOptions = $maxOneWayOptions;
        return $this;
    }
    /**
     * Get NumOneWayOptions value
     * @return \SabreSoap\StructType\NumOneWayOptions|null
     */
    public function getNumOneWayOptions()
    {
        return $this->NumOneWayOptions;
    }
    /**
     * Set NumOneWayOptions value
     * @param \SabreSoap\StructType\NumOneWayOptions $numOneWayOptions
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOneWayOptions(\SabreSoap\StructType\NumOneWayOptions $numOneWayOptions = null)
    {
        $this->NumOneWayOptions = $numOneWayOptions;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \SabreSoap\StructType\CabinPrefType|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @param \SabreSoap\StructType\CabinPrefType $cabinPref
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setCabinPref(\SabreSoap\StructType\CabinPrefType $cabinPref = null)
    {
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Get ConnectionTime value
     * @return \SabreSoap\StructType\ConnectionTime|null
     */
    public function getConnectionTime()
    {
        return $this->ConnectionTime;
    }
    /**
     * Set ConnectionTime value
     * @param \SabreSoap\StructType\ConnectionTime $connectionTime
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setConnectionTime(\SabreSoap\StructType\ConnectionTime $connectionTime = null)
    {
        $this->ConnectionTime = $connectionTime;
        return $this;
    }
    /**
     * Get TotalTravelTime value
     * @return \SabreSoap\StructType\TotalTravelTime|null
     */
    public function getTotalTravelTime()
    {
        return $this->TotalTravelTime;
    }
    /**
     * Set TotalTravelTime value
     * @param \SabreSoap\StructType\TotalTravelTime $totalTravelTime
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setTotalTravelTime(\SabreSoap\StructType\TotalTravelTime $totalTravelTime = null)
    {
        $this->TotalTravelTime = $totalTravelTime;
        return $this;
    }
    /**
     * Get IncludeVendorPref value
     * @return \SabreSoap\StructType\IncludeVendorPrefType[]|null
     */
    public function getIncludeVendorPref()
    {
        return $this->IncludeVendorPref;
    }
    /**
     * Set IncludeVendorPref value
     * @param \SabreSoap\StructType\IncludeVendorPrefType[] $includeVendorPref
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setIncludeVendorPref(array $includeVendorPref = array())
    {
        $this->IncludeVendorPref = $includeVendorPref;
        return $this;
    }
    /**
     * Add item to IncludeVendorPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\IncludeVendorPrefType $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToIncludeVendorPref(\SabreSoap\StructType\IncludeVendorPrefType $item)
    {
        $this->IncludeVendorPref[] = $item;
        return $this;
    }
    /**
     * Get IncludeAlliancePref value
     * @return \SabreSoap\StructType\AllianceType[]|null
     */
    public function getIncludeAlliancePref()
    {
        return $this->IncludeAlliancePref;
    }
    /**
     * Set IncludeAlliancePref value
     * @param \SabreSoap\StructType\AllianceType[] $includeAlliancePref
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setIncludeAlliancePref(array $includeAlliancePref = array())
    {
        $this->IncludeAlliancePref = $includeAlliancePref;
        return $this;
    }
    /**
     * Add item to IncludeAlliancePref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AllianceType $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToIncludeAlliancePref(\SabreSoap\StructType\AllianceType $item)
    {
        $this->IncludeAlliancePref[] = $item;
        return $this;
    }
    /**
     * Get DepartureDays value
     * @return \SabreSoap\StructType\DepartureDaysType|null
     */
    public function getDepartureDays()
    {
        return $this->DepartureDays;
    }
    /**
     * Set DepartureDays value
     * @param \SabreSoap\StructType\DepartureDaysType $departureDays
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDepartureDays(\SabreSoap\StructType\DepartureDaysType $departureDays = null)
    {
        $this->DepartureDays = $departureDays;
        return $this;
    }
    /**
     * Get IntelliSellTransaction value
     * @return \SabreSoap\StructType\TransactionType|null
     */
    public function getIntelliSellTransaction()
    {
        return $this->IntelliSellTransaction;
    }
    /**
     * Set IntelliSellTransaction value
     * @param \SabreSoap\StructType\TransactionType $intelliSellTransaction
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setIntelliSellTransaction(\SabreSoap\StructType\TransactionType $intelliSellTransaction = null)
    {
        $this->IntelliSellTransaction = $intelliSellTransaction;
        return $this;
    }
    /**
     * Get DiversityControl value
     * @return \SabreSoap\StructType\DiversityControlType|null
     */
    public function getDiversityControl()
    {
        return $this->DiversityControl;
    }
    /**
     * Set DiversityControl value
     * @param \SabreSoap\StructType\DiversityControlType $diversityControl
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDiversityControl(\SabreSoap\StructType\DiversityControlType $diversityControl = null)
    {
        $this->DiversityControl = $diversityControl;
        return $this;
    }
    /**
     * Get MessagingDetails value
     * @return \SabreSoap\StructType\MessagingDetails|null
     */
    public function getMessagingDetails()
    {
        return $this->MessagingDetails;
    }
    /**
     * Set MessagingDetails value
     * @param \SabreSoap\StructType\MessagingDetails $messagingDetails
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMessagingDetails(\SabreSoap\StructType\MessagingDetails $messagingDetails = null)
    {
        $this->MessagingDetails = $messagingDetails;
        return $this;
    }
    /**
     * Get AlternateAirportCities value
     * @return \SabreSoap\StructType\AlternateAirportCities[]|null
     */
    public function getAlternateAirportCities()
    {
        return isset($this->AlternateAirportCities) ? $this->AlternateAirportCities : null;
    }
    /**
     * Set AlternateAirportCities value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\AlternateAirportCities[] $alternateAirportCities
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAlternateAirportCities(array $alternateAirportCities = array())
    {
        if (is_null($alternateAirportCities) || (is_array($alternateAirportCities) && empty($alternateAirportCities))) {
            unset($this->AlternateAirportCities);
        } else {
            $this->AlternateAirportCities = $alternateAirportCities;
        }
        return $this;
    }
    /**
     * Add item to AlternateAirportCities value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AlternateAirportCities $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToAlternateAirportCities(\SabreSoap\StructType\AlternateAirportCities $item)
    {
        $this->AlternateAirportCities[] = $item;
        return $this;
    }
    /**
     * Get AlternateAirportMileage value
     * @return \SabreSoap\StructType\AlternateAirportMileage|null
     */
    public function getAlternateAirportMileage()
    {
        return isset($this->AlternateAirportMileage) ? $this->AlternateAirportMileage : null;
    }
    /**
     * Set AlternateAirportMileage value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\AlternateAirportMileage $alternateAirportMileage
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAlternateAirportMileage(\SabreSoap\StructType\AlternateAirportMileage $alternateAirportMileage = null)
    {
        if (is_null($alternateAirportMileage) || (is_array($alternateAirportMileage) && empty($alternateAirportMileage))) {
            unset($this->AlternateAirportMileage);
        } else {
            $this->AlternateAirportMileage = $alternateAirportMileage;
        }
        return $this;
    }
    /**
     * Get SplitTaxes value
     * @return \SabreSoap\StructType\SplitTaxes|null
     */
    public function getSplitTaxes()
    {
        return $this->SplitTaxes;
    }
    /**
     * Set SplitTaxes value
     * @param \SabreSoap\StructType\SplitTaxes $splitTaxes
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSplitTaxes(\SabreSoap\StructType\SplitTaxes $splitTaxes = null)
    {
        $this->SplitTaxes = $splitTaxes;
        return $this;
    }
    /**
     * Get MultiTicket value
     * @return \SabreSoap\StructType\MultiTicket|null
     */
    public function getMultiTicket()
    {
        return $this->MultiTicket;
    }
    /**
     * Set MultiTicket value
     * @param \SabreSoap\StructType\MultiTicket $multiTicket
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMultiTicket(\SabreSoap\StructType\MultiTicket $multiTicket = null)
    {
        $this->MultiTicket = $multiTicket;
        return $this;
    }
    /**
     * Get Partitions value
     * @return \SabreSoap\StructType\Partitions|null
     */
    public function getPartitions()
    {
        return $this->Partitions;
    }
    /**
     * Set Partitions value
     * @param \SabreSoap\StructType\Partitions $partitions
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPartitions(\SabreSoap\StructType\Partitions $partitions = null)
    {
        $this->Partitions = $partitions;
        return $this;
    }
    /**
     * Get ReservationData value
     * @return \SabreSoap\StructType\ReservationData|null
     */
    public function getReservationData()
    {
        return $this->ReservationData;
    }
    /**
     * Set ReservationData value
     * @param \SabreSoap\StructType\ReservationData $reservationData
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setReservationData(\SabreSoap\StructType\ReservationData $reservationData = null)
    {
        $this->ReservationData = $reservationData;
        return $this;
    }
    /**
     * Get AlternatePCC value
     * @return \SabreSoap\StructType\AlternatePCC[]|null
     */
    public function getAlternatePCC()
    {
        return $this->AlternatePCC;
    }
    /**
     * Set AlternatePCC value
     * @param \SabreSoap\StructType\AlternatePCC[] $alternatePCC
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAlternatePCC(array $alternatePCC = array())
    {
        $this->AlternatePCC = $alternatePCC;
        return $this;
    }
    /**
     * Add item to AlternatePCC value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AlternatePCC $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToAlternatePCC(\SabreSoap\StructType\AlternatePCC $item)
    {
        $this->AlternatePCC[] = $item;
        return $this;
    }
    /**
     * Get ExcludeAlliancePref value
     * @return \SabreSoap\StructType\AllianceType[]|null
     */
    public function getExcludeAlliancePref()
    {
        return $this->ExcludeAlliancePref;
    }
    /**
     * Set ExcludeAlliancePref value
     * @param \SabreSoap\StructType\AllianceType[] $excludeAlliancePref
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setExcludeAlliancePref(array $excludeAlliancePref = array())
    {
        $this->ExcludeAlliancePref = $excludeAlliancePref;
        return $this;
    }
    /**
     * Add item to ExcludeAlliancePref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AllianceType $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToExcludeAlliancePref(\SabreSoap\StructType\AllianceType $item)
    {
        $this->ExcludeAlliancePref[] = $item;
        return $this;
    }
    /**
     * Get PublicFare value
     * @return \SabreSoap\StructType\PublicFare|null
     */
    public function getPublicFare()
    {
        return $this->PublicFare;
    }
    /**
     * Set PublicFare value
     * @param \SabreSoap\StructType\PublicFare $publicFare
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPublicFare(\SabreSoap\StructType\PublicFare $publicFare = null)
    {
        $this->PublicFare = $publicFare;
        return $this;
    }
    /**
     * Get PrivateFare value
     * @return \SabreSoap\StructType\PrivateFare|null
     */
    public function getPrivateFare()
    {
        return $this->PrivateFare;
    }
    /**
     * Set PrivateFare value
     * @param \SabreSoap\StructType\PrivateFare $privateFare
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPrivateFare(\SabreSoap\StructType\PrivateFare $privateFare = null)
    {
        $this->PrivateFare = $privateFare;
        return $this;
    }
    /**
     * Get Priority value
     * @return \SabreSoap\StructType\Priority|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param \SabreSoap\StructType\Priority $priority
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPriority(\SabreSoap\StructType\Priority $priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Indicators value
     * @return \SabreSoap\StructType\Indicators|null
     */
    public function getIndicators()
    {
        return $this->Indicators;
    }
    /**
     * Set Indicators value
     * @param \SabreSoap\StructType\Indicators $indicators
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setIndicators(\SabreSoap\StructType\Indicators $indicators = null)
    {
        $this->Indicators = $indicators;
        return $this;
    }
    /**
     * Get PromoID value
     * @return string|null
     */
    public function getPromoID()
    {
        return $this->PromoID;
    }
    /**
     * Set PromoID value
     * @param string $promoID
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPromoID($promoID = null)
    {
        $this->PromoID = $promoID;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return \SabreSoap\StructType\CustomerType|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param \SabreSoap\StructType\CustomerType $customerType
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setCustomerType(\SabreSoap\StructType\CustomerType $customerType = null)
    {
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get MultipleTravelerGroups value
     * @return \SabreSoap\StructType\MultipleTravelerGroups|null
     */
    public function getMultipleTravelerGroups()
    {
        return $this->MultipleTravelerGroups;
    }
    /**
     * Set MultipleTravelerGroups value
     * @param \SabreSoap\StructType\MultipleTravelerGroups $multipleTravelerGroups
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMultipleTravelerGroups(\SabreSoap\StructType\MultipleTravelerGroups $multipleTravelerGroups = null)
    {
        $this->MultipleTravelerGroups = $multipleTravelerGroups;
        return $this;
    }
    /**
     * Get BrandedFareIndicators value
     * @return \SabreSoap\StructType\BrandedFareIndicators|null
     */
    public function getBrandedFareIndicators()
    {
        return $this->BrandedFareIndicators;
    }
    /**
     * Set BrandedFareIndicators value
     * @param \SabreSoap\StructType\BrandedFareIndicators $brandedFareIndicators
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setBrandedFareIndicators(\SabreSoap\StructType\BrandedFareIndicators $brandedFareIndicators = null)
    {
        $this->BrandedFareIndicators = $brandedFareIndicators;
        return $this;
    }
    /**
     * Get PassengerStatus value
     * @return \SabreSoap\StructType\PassengerStatus|null
     */
    public function getPassengerStatus()
    {
        return $this->PassengerStatus;
    }
    /**
     * Set PassengerStatus value
     * @param \SabreSoap\StructType\PassengerStatus $passengerStatus
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPassengerStatus(\SabreSoap\StructType\PassengerStatus $passengerStatus = null)
    {
        $this->PassengerStatus = $passengerStatus;
        return $this;
    }
    /**
     * Get PointOfSaleOverride value
     * @return \SabreSoap\StructType\PointOfSaleOverrideType|null
     */
    public function getPointOfSaleOverride()
    {
        return $this->PointOfSaleOverride;
    }
    /**
     * Set PointOfSaleOverride value
     * @param \SabreSoap\StructType\PointOfSaleOverrideType $pointOfSaleOverride
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPointOfSaleOverride(\SabreSoap\StructType\PointOfSaleOverrideType $pointOfSaleOverride = null)
    {
        $this->PointOfSaleOverride = $pointOfSaleOverride;
        return $this;
    }
    /**
     * Get PointOfTicketingOverride value
     * @return \SabreSoap\StructType\PointOfTicketingOverrideType|null
     */
    public function getPointOfTicketingOverride()
    {
        return $this->PointOfTicketingOverride;
    }
    /**
     * Set PointOfTicketingOverride value
     * @param \SabreSoap\StructType\PointOfTicketingOverrideType $pointOfTicketingOverride
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPointOfTicketingOverride(\SabreSoap\StructType\PointOfTicketingOverrideType $pointOfTicketingOverride = null)
    {
        $this->PointOfTicketingOverride = $pointOfTicketingOverride;
        return $this;
    }
    /**
     * Get OBFees value
     * @return \SabreSoap\StructType\OBFees|null
     */
    public function getOBFees()
    {
        return $this->OBFees;
    }
    /**
     * Set OBFees value
     * @param \SabreSoap\StructType\OBFees $oBFees
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setOBFees(\SabreSoap\StructType\OBFees $oBFees = null)
    {
        $this->OBFees = $oBFees;
        return $this;
    }
    /**
     * Get FareBreaksAtLegs value
     * @return \SabreSoap\StructType\FareBreaksAtLegs|null
     */
    public function getFareBreaksAtLegs()
    {
        return $this->FareBreaksAtLegs;
    }
    /**
     * Set FareBreaksAtLegs value
     * @param \SabreSoap\StructType\FareBreaksAtLegs $fareBreaksAtLegs
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFareBreaksAtLegs(\SabreSoap\StructType\FareBreaksAtLegs $fareBreaksAtLegs = null)
    {
        $this->FareBreaksAtLegs = $fareBreaksAtLegs;
        return $this;
    }
    /**
     * Get DepartureWindow value
     * @return string|null
     */
    public function getDepartureWindow()
    {
        return $this->DepartureWindow;
    }
    /**
     * Set DepartureWindow value
     * @param string $departureWindow
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDepartureWindow($departureWindow = null)
    {
        $this->DepartureWindow = $departureWindow;
        return $this;
    }
    /**
     * Get ArrivalWindow value
     * @return string|null
     */
    public function getArrivalWindow()
    {
        return $this->ArrivalWindow;
    }
    /**
     * Set ArrivalWindow value
     * @param string $arrivalWindow
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setArrivalWindow($arrivalWindow = null)
    {
        $this->ArrivalWindow = $arrivalWindow;
        return $this;
    }
    /**
     * Get ExcludeVendorPref value
     * @return \SabreSoap\StructType\ExcludeVendorPref[]|null
     */
    public function getExcludeVendorPref()
    {
        return $this->ExcludeVendorPref;
    }
    /**
     * Set ExcludeVendorPref value
     * @param \SabreSoap\StructType\ExcludeVendorPref[] $excludeVendorPref
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setExcludeVendorPref(array $excludeVendorPref = array())
    {
        $this->ExcludeVendorPref = $excludeVendorPref;
        return $this;
    }
    /**
     * Add item to ExcludeVendorPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ExcludeVendorPref $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToExcludeVendorPref(\SabreSoap\StructType\ExcludeVendorPref $item)
    {
        $this->ExcludeVendorPref[] = $item;
        return $this;
    }
    /**
     * Get NumTrips value
     * @return \SabreSoap\StructType\NumTripsType|null
     */
    public function getNumTrips()
    {
        return $this->NumTrips;
    }
    /**
     * Set NumTrips value
     * @param \SabreSoap\StructType\NumTripsType $numTrips
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumTrips(\SabreSoap\StructType\NumTripsType $numTrips = null)
    {
        $this->NumTrips = $numTrips;
        return $this;
    }
    /**
     * Get AltCitiesCombinations value
     * @return \SabreSoap\StructType\AltCitiesCombinationsType|null
     */
    public function getAltCitiesCombinations()
    {
        return $this->AltCitiesCombinations;
    }
    /**
     * Set AltCitiesCombinations value
     * @param \SabreSoap\StructType\AltCitiesCombinationsType $altCitiesCombinations
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAltCitiesCombinations(\SabreSoap\StructType\AltCitiesCombinationsType $altCitiesCombinations = null)
    {
        $this->AltCitiesCombinations = $altCitiesCombinations;
        return $this;
    }
    /**
     * Get NumTripsWithRouting value
     * @return \SabreSoap\StructType\NumTripsWithRouting|null
     */
    public function getNumTripsWithRouting()
    {
        return $this->NumTripsWithRouting;
    }
    /**
     * Set NumTripsWithRouting value
     * @param \SabreSoap\StructType\NumTripsWithRouting $numTripsWithRouting
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumTripsWithRouting(\SabreSoap\StructType\NumTripsWithRouting $numTripsWithRouting = null)
    {
        $this->NumTripsWithRouting = $numTripsWithRouting;
        return $this;
    }
    /**
     * Get OnlineIndicator value
     * @return \SabreSoap\StructType\OnlineIndicator|null
     */
    public function getOnlineIndicator()
    {
        return $this->OnlineIndicator;
    }
    /**
     * Set OnlineIndicator value
     * @param \SabreSoap\StructType\OnlineIndicator $onlineIndicator
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setOnlineIndicator(\SabreSoap\StructType\OnlineIndicator $onlineIndicator = null)
    {
        $this->OnlineIndicator = $onlineIndicator;
        return $this;
    }
    /**
     * Get InterlineIndicator value
     * @return \SabreSoap\StructType\InterlineIndicator|null
     */
    public function getInterlineIndicator()
    {
        return $this->InterlineIndicator;
    }
    /**
     * Set InterlineIndicator value
     * @param \SabreSoap\StructType\InterlineIndicator $interlineIndicator
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setInterlineIndicator(\SabreSoap\StructType\InterlineIndicator $interlineIndicator = null)
    {
        $this->InterlineIndicator = $interlineIndicator;
        return $this;
    }
    /**
     * Get TripType value
     * @return \SabreSoap\StructType\TripType|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @param \SabreSoap\StructType\TripType $tripType
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setTripType(\SabreSoap\StructType\TripType $tripType = null)
    {
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get MaxPrice value
     * @return \SabreSoap\StructType\MaxPrice|null
     */
    public function getMaxPrice()
    {
        return $this->MaxPrice;
    }
    /**
     * Set MaxPrice value
     * @param \SabreSoap\StructType\MaxPrice $maxPrice
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxPrice(\SabreSoap\StructType\MaxPrice $maxPrice = null)
    {
        $this->MaxPrice = $maxPrice;
        return $this;
    }
    /**
     * Get DomesticLayoverTime value
     * @return \SabreSoap\StructType\DomesticLayoverTime|null
     */
    public function getDomesticLayoverTime()
    {
        return $this->DomesticLayoverTime;
    }
    /**
     * Set DomesticLayoverTime value
     * @param \SabreSoap\StructType\DomesticLayoverTime $domesticLayoverTime
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDomesticLayoverTime(\SabreSoap\StructType\DomesticLayoverTime $domesticLayoverTime = null)
    {
        $this->DomesticLayoverTime = $domesticLayoverTime;
        return $this;
    }
    /**
     * Get LongConnectTime value
     * @return \SabreSoap\StructType\LongConnectTime|null
     */
    public function getLongConnectTime()
    {
        return $this->LongConnectTime;
    }
    /**
     * Set LongConnectTime value
     * @param \SabreSoap\StructType\LongConnectTime $longConnectTime
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setLongConnectTime(\SabreSoap\StructType\LongConnectTime $longConnectTime = null)
    {
        $this->LongConnectTime = $longConnectTime;
        return $this;
    }
    /**
     * Get LongConnectPoints value
     * @return \SabreSoap\StructType\LongConnectPoints|null
     */
    public function getLongConnectPoints()
    {
        return $this->LongConnectPoints;
    }
    /**
     * Set LongConnectPoints value
     * @param \SabreSoap\StructType\LongConnectPoints $longConnectPoints
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setLongConnectPoints(\SabreSoap\StructType\LongConnectPoints $longConnectPoints = null)
    {
        $this->LongConnectPoints = $longConnectPoints;
        return $this;
    }
    /**
     * Get AirServiceOnly value
     * @return \SabreSoap\StructType\AirServiceOnly|null
     */
    public function getAirServiceOnly()
    {
        return $this->AirServiceOnly;
    }
    /**
     * Set AirServiceOnly value
     * @param \SabreSoap\StructType\AirServiceOnly $airServiceOnly
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAirServiceOnly(\SabreSoap\StructType\AirServiceOnly $airServiceOnly = null)
    {
        $this->AirServiceOnly = $airServiceOnly;
        return $this;
    }
    /**
     * Get JetServiceOnly value
     * @return \SabreSoap\StructType\JetServiceOnly|null
     */
    public function getJetServiceOnly()
    {
        return $this->JetServiceOnly;
    }
    /**
     * Set JetServiceOnly value
     * @param \SabreSoap\StructType\JetServiceOnly $jetServiceOnly
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setJetServiceOnly(\SabreSoap\StructType\JetServiceOnly $jetServiceOnly = null)
    {
        $this->JetServiceOnly = $jetServiceOnly;
        return $this;
    }
    /**
     * Get SameConnectionAirportOnly value
     * @return \SabreSoap\StructType\SameConnectionAirportOnly|null
     */
    public function getSameConnectionAirportOnly()
    {
        return $this->SameConnectionAirportOnly;
    }
    /**
     * Set SameConnectionAirportOnly value
     * @param \SabreSoap\StructType\SameConnectionAirportOnly $sameConnectionAirportOnly
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSameConnectionAirportOnly(\SabreSoap\StructType\SameConnectionAirportOnly $sameConnectionAirportOnly = null)
    {
        $this->SameConnectionAirportOnly = $sameConnectionAirportOnly;
        return $this;
    }
    /**
     * Get SameOriginAirportOnly value
     * @return \SabreSoap\StructType\SameOriginAirportOnly|null
     */
    public function getSameOriginAirportOnly()
    {
        return $this->SameOriginAirportOnly;
    }
    /**
     * Set SameOriginAirportOnly value
     * @param \SabreSoap\StructType\SameOriginAirportOnly $sameOriginAirportOnly
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSameOriginAirportOnly(\SabreSoap\StructType\SameOriginAirportOnly $sameOriginAirportOnly = null)
    {
        $this->SameOriginAirportOnly = $sameOriginAirportOnly;
        return $this;
    }
    /**
     * Get SameTurnaroundAirportOnly value
     * @return \SabreSoap\StructType\SameTurnaroundAirportOnly|null
     */
    public function getSameTurnaroundAirportOnly()
    {
        return $this->SameTurnaroundAirportOnly;
    }
    /**
     * Set SameTurnaroundAirportOnly value
     * @param \SabreSoap\StructType\SameTurnaroundAirportOnly $sameTurnaroundAirportOnly
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSameTurnaroundAirportOnly(\SabreSoap\StructType\SameTurnaroundAirportOnly $sameTurnaroundAirportOnly = null)
    {
        $this->SameTurnaroundAirportOnly = $sameTurnaroundAirportOnly;
        return $this;
    }
    /**
     * Get AircraftTypePenalty value
     * @return \SabreSoap\StructType\AircraftTypePenalty|null
     */
    public function getAircraftTypePenalty()
    {
        return $this->AircraftTypePenalty;
    }
    /**
     * Set AircraftTypePenalty value
     * @param \SabreSoap\StructType\AircraftTypePenalty $aircraftTypePenalty
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAircraftTypePenalty(\SabreSoap\StructType\AircraftTypePenalty $aircraftTypePenalty = null)
    {
        $this->AircraftTypePenalty = $aircraftTypePenalty;
        return $this;
    }
    /**
     * Get AlternateAirportPenalty value
     * @return \SabreSoap\StructType\AlternateAirportPenalty|null
     */
    public function getAlternateAirportPenalty()
    {
        return $this->AlternateAirportPenalty;
    }
    /**
     * Set AlternateAirportPenalty value
     * @param \SabreSoap\StructType\AlternateAirportPenalty $alternateAirportPenalty
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAlternateAirportPenalty(\SabreSoap\StructType\AlternateAirportPenalty $alternateAirportPenalty = null)
    {
        $this->AlternateAirportPenalty = $alternateAirportPenalty;
        return $this;
    }
    /**
     * Get FareAmountThreshold value
     * @return \SabreSoap\StructType\FareAmountThreshold|null
     */
    public function getFareAmountThreshold()
    {
        return $this->FareAmountThreshold;
    }
    /**
     * Set FareAmountThreshold value
     * @param \SabreSoap\StructType\FareAmountThreshold $fareAmountThreshold
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFareAmountThreshold(\SabreSoap\StructType\FareAmountThreshold $fareAmountThreshold = null)
    {
        $this->FareAmountThreshold = $fareAmountThreshold;
        return $this;
    }
    /**
     * Get numOfLowFareSol value
     * @return \SabreSoap\StructType\NumOfLowFareSol|null
     */
    public function getNumOfLowFareSol()
    {
        return $this->numOfLowFareSol;
    }
    /**
     * Set numOfLowFareSol value
     * @param \SabreSoap\StructType\NumOfLowFareSol $numOfLowFareSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfLowFareSol(\SabreSoap\StructType\NumOfLowFareSol $numOfLowFareSol = null)
    {
        $this->numOfLowFareSol = $numOfLowFareSol;
        return $this;
    }
    /**
     * Get numOfMustPriceOnlSol value
     * @return \SabreSoap\StructType\NumOfMustPriceOnlSol|null
     */
    public function getNumOfMustPriceOnlSol()
    {
        return $this->numOfMustPriceOnlSol;
    }
    /**
     * Set numOfMustPriceOnlSol value
     * @param \SabreSoap\StructType\NumOfMustPriceOnlSol $numOfMustPriceOnlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPriceOnlSol(\SabreSoap\StructType\NumOfMustPriceOnlSol $numOfMustPriceOnlSol = null)
    {
        $this->numOfMustPriceOnlSol = $numOfMustPriceOnlSol;
        return $this;
    }
    /**
     * Get numOfMustPriceInrlSol value
     * @return \SabreSoap\StructType\NumOfMustPriceInrlSol|null
     */
    public function getNumOfMustPriceInrlSol()
    {
        return $this->numOfMustPriceInrlSol;
    }
    /**
     * Set numOfMustPriceInrlSol value
     * @param \SabreSoap\StructType\NumOfMustPriceInrlSol $numOfMustPriceInrlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPriceInrlSol(\SabreSoap\StructType\NumOfMustPriceInrlSol $numOfMustPriceInrlSol = null)
    {
        $this->numOfMustPriceInrlSol = $numOfMustPriceInrlSol;
        return $this;
    }
    /**
     * Get numOfMustPriceNStpOnlSol value
     * @return \SabreSoap\StructType\NumOfMustPriceNStpOnlSol|null
     */
    public function getNumOfMustPriceNStpOnlSol()
    {
        return $this->numOfMustPriceNStpOnlSol;
    }
    /**
     * Set numOfMustPriceNStpOnlSol value
     * @param \SabreSoap\StructType\NumOfMustPriceNStpOnlSol $numOfMustPriceNStpOnlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPriceNStpOnlSol(\SabreSoap\StructType\NumOfMustPriceNStpOnlSol $numOfMustPriceNStpOnlSol = null)
    {
        $this->numOfMustPriceNStpOnlSol = $numOfMustPriceNStpOnlSol;
        return $this;
    }
    /**
     * Get numOfMustPriceNStpInrlSol value
     * @return \SabreSoap\StructType\NumOfMustPriceNStpInrlSol|null
     */
    public function getNumOfMustPriceNStpInrlSol()
    {
        return $this->numOfMustPriceNStpInrlSol;
    }
    /**
     * Set numOfMustPriceNStpInrlSol value
     * @param \SabreSoap\StructType\NumOfMustPriceNStpInrlSol $numOfMustPriceNStpInrlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPriceNStpInrlSol(\SabreSoap\StructType\NumOfMustPriceNStpInrlSol $numOfMustPriceNStpInrlSol = null)
    {
        $this->numOfMustPriceNStpInrlSol = $numOfMustPriceNStpInrlSol;
        return $this;
    }
    /**
     * Get numOfMustPriceSStopOnlSol value
     * @return \SabreSoap\StructType\NumOfMustPriceSStopOnlSol|null
     */
    public function getNumOfMustPriceSStopOnlSol()
    {
        return $this->numOfMustPriceSStopOnlSol;
    }
    /**
     * Set numOfMustPriceSStopOnlSol value
     * @param \SabreSoap\StructType\NumOfMustPriceSStopOnlSol $numOfMustPriceSStopOnlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPriceSStopOnlSol(\SabreSoap\StructType\NumOfMustPriceSStopOnlSol $numOfMustPriceSStopOnlSol = null)
    {
        $this->numOfMustPriceSStopOnlSol = $numOfMustPriceSStopOnlSol;
        return $this;
    }
    /**
     * Get stpPenaltyInUSD value
     * @return \SabreSoap\StructType\StpPenaltyInUSD|null
     */
    public function getStpPenaltyInUSD()
    {
        return $this->stpPenaltyInUSD;
    }
    /**
     * Set stpPenaltyInUSD value
     * @param \SabreSoap\StructType\StpPenaltyInUSD $stpPenaltyInUSD
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setStpPenaltyInUSD(\SabreSoap\StructType\StpPenaltyInUSD $stpPenaltyInUSD = null)
    {
        $this->stpPenaltyInUSD = $stpPenaltyInUSD;
        return $this;
    }
    /**
     * Get durPenaltyInUSD value
     * @return \SabreSoap\StructType\DurPenaltyInUSD|null
     */
    public function getDurPenaltyInUSD()
    {
        return $this->durPenaltyInUSD;
    }
    /**
     * Set durPenaltyInUSD value
     * @param \SabreSoap\StructType\DurPenaltyInUSD $durPenaltyInUSD
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDurPenaltyInUSD(\SabreSoap\StructType\DurPenaltyInUSD $durPenaltyInUSD = null)
    {
        $this->durPenaltyInUSD = $durPenaltyInUSD;
        return $this;
    }
    /**
     * Get depPenaltyInUSD value
     * @return \SabreSoap\StructType\DepPenaltyInUSD|null
     */
    public function getDepPenaltyInUSD()
    {
        return $this->depPenaltyInUSD;
    }
    /**
     * Set depPenaltyInUSD value
     * @param \SabreSoap\StructType\DepPenaltyInUSD $depPenaltyInUSD
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDepPenaltyInUSD(\SabreSoap\StructType\DepPenaltyInUSD $depPenaltyInUSD = null)
    {
        $this->depPenaltyInUSD = $depPenaltyInUSD;
        return $this;
    }
    /**
     * Get maxAllowedMustPriceOveragePerCrr value
     * @return \SabreSoap\StructType\MaxAllowedMustPriceOveragePerCrr|null
     */
    public function getMaxAllowedMustPriceOveragePerCrr()
    {
        return $this->maxAllowedMustPriceOveragePerCrr;
    }
    /**
     * Set maxAllowedMustPriceOveragePerCrr value
     * @param \SabreSoap\StructType\MaxAllowedMustPriceOveragePerCrr $maxAllowedMustPriceOveragePerCrr
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxAllowedMustPriceOveragePerCrr(\SabreSoap\StructType\MaxAllowedMustPriceOveragePerCrr $maxAllowedMustPriceOveragePerCrr = null)
    {
        $this->maxAllowedMustPriceOveragePerCrr = $maxAllowedMustPriceOveragePerCrr;
        return $this;
    }
    /**
     * Get fltOptMustPriceReuseLimit value
     * @return \SabreSoap\StructType\FltOptMustPriceReuseLimit|null
     */
    public function getFltOptMustPriceReuseLimit()
    {
        return $this->fltOptMustPriceReuseLimit;
    }
    /**
     * Set fltOptMustPriceReuseLimit value
     * @param \SabreSoap\StructType\FltOptMustPriceReuseLimit $fltOptMustPriceReuseLimit
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFltOptMustPriceReuseLimit(\SabreSoap\StructType\FltOptMustPriceReuseLimit $fltOptMustPriceReuseLimit = null)
    {
        $this->fltOptMustPriceReuseLimit = $fltOptMustPriceReuseLimit;
        return $this;
    }
    /**
     * Get upperBoundMustPriceFactorForNotNonStp value
     * @return \SabreSoap\StructType\UpperBoundMustPriceFactorForNotNonStp|null
     */
    public function getUpperBoundMustPriceFactorForNotNonStp()
    {
        return $this->upperBoundMustPriceFactorForNotNonStp;
    }
    /**
     * Set upperBoundMustPriceFactorForNotNonStp value
     * @param \SabreSoap\StructType\UpperBoundMustPriceFactorForNotNonStp $upperBoundMustPriceFactorForNotNonStp
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setUpperBoundMustPriceFactorForNotNonStp(\SabreSoap\StructType\UpperBoundMustPriceFactorForNotNonStp $upperBoundMustPriceFactorForNotNonStp = null)
    {
        $this->upperBoundMustPriceFactorForNotNonStp = $upperBoundMustPriceFactorForNotNonStp;
        return $this;
    }
    /**
     * Get upperBoundLFSFactor value
     * @return \SabreSoap\StructType\UpperBoundLFSFactor|null
     */
    public function getUpperBoundLFSFactor()
    {
        return $this->upperBoundLFSFactor;
    }
    /**
     * Set upperBoundLFSFactor value
     * @param \SabreSoap\StructType\UpperBoundLFSFactor $upperBoundLFSFactor
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setUpperBoundLFSFactor(\SabreSoap\StructType\UpperBoundLFSFactor $upperBoundLFSFactor = null)
    {
        $this->upperBoundLFSFactor = $upperBoundLFSFactor;
        return $this;
    }
    /**
     * Get numOfMustPriceNStp1StpOnlSol value
     * @return \SabreSoap\StructType\NumOfMustPriceNStp1StpOnlSol|null
     */
    public function getNumOfMustPriceNStp1StpOnlSol()
    {
        return $this->numOfMustPriceNStp1StpOnlSol;
    }
    /**
     * Set numOfMustPriceNStp1StpOnlSol value
     * @param \SabreSoap\StructType\NumOfMustPriceNStp1StpOnlSol $numOfMustPriceNStp1StpOnlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPriceNStp1StpOnlSol(\SabreSoap\StructType\NumOfMustPriceNStp1StpOnlSol $numOfMustPriceNStp1StpOnlSol = null)
    {
        $this->numOfMustPriceNStp1StpOnlSol = $numOfMustPriceNStp1StpOnlSol;
        return $this;
    }
    /**
     * Get numOfMustPriceNStp1StpInrlSol value
     * @return \SabreSoap\StructType\NumOfMustPriceNStp1StpInrlSol|null
     */
    public function getNumOfMustPriceNStp1StpInrlSol()
    {
        return $this->numOfMustPriceNStp1StpInrlSol;
    }
    /**
     * Set numOfMustPriceNStp1StpInrlSol value
     * @param \SabreSoap\StructType\NumOfMustPriceNStp1StpInrlSol $numOfMustPriceNStp1StpInrlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPriceNStp1StpInrlSol(\SabreSoap\StructType\NumOfMustPriceNStp1StpInrlSol $numOfMustPriceNStp1StpInrlSol = null)
    {
        $this->numOfMustPriceNStp1StpInrlSol = $numOfMustPriceNStp1StpInrlSol;
        return $this;
    }
    /**
     * Get upperBoundMustPriceFactorForNonStp value
     * @return \SabreSoap\StructType\UpperBoundMustPriceFactorForNonStp|null
     */
    public function getUpperBoundMustPriceFactorForNonStp()
    {
        return $this->upperBoundMustPriceFactorForNonStp;
    }
    /**
     * Set upperBoundMustPriceFactorForNonStp value
     * @param \SabreSoap\StructType\UpperBoundMustPriceFactorForNonStp $upperBoundMustPriceFactorForNonStp
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setUpperBoundMustPriceFactorForNonStp(\SabreSoap\StructType\UpperBoundMustPriceFactorForNonStp $upperBoundMustPriceFactorForNonStp = null)
    {
        $this->upperBoundMustPriceFactorForNonStp = $upperBoundMustPriceFactorForNonStp;
        return $this;
    }
    /**
     * Get maxAllowedLFSOveragePerCrrPercent value
     * @return \SabreSoap\StructType\MaxAllowedLFSOveragePerCrrPercent|null
     */
    public function getMaxAllowedLFSOveragePerCrrPercent()
    {
        return $this->maxAllowedLFSOveragePerCrrPercent;
    }
    /**
     * Set maxAllowedLFSOveragePerCrrPercent value
     * @param \SabreSoap\StructType\MaxAllowedLFSOveragePerCrrPercent $maxAllowedLFSOveragePerCrrPercent
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxAllowedLFSOveragePerCrrPercent(\SabreSoap\StructType\MaxAllowedLFSOveragePerCrrPercent $maxAllowedLFSOveragePerCrrPercent = null)
    {
        $this->maxAllowedLFSOveragePerCrrPercent = $maxAllowedLFSOveragePerCrrPercent;
        return $this;
    }
    /**
     * Get targetMinNumOfLFSOnlSolPerCrr value
     * @return \SabreSoap\StructType\TargetMinNumOfLFSOnlSolPerCrr|null
     */
    public function getTargetMinNumOfLFSOnlSolPerCrr()
    {
        return $this->targetMinNumOfLFSOnlSolPerCrr;
    }
    /**
     * Set targetMinNumOfLFSOnlSolPerCrr value
     * @param \SabreSoap\StructType\TargetMinNumOfLFSOnlSolPerCrr $targetMinNumOfLFSOnlSolPerCrr
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setTargetMinNumOfLFSOnlSolPerCrr(\SabreSoap\StructType\TargetMinNumOfLFSOnlSolPerCrr $targetMinNumOfLFSOnlSolPerCrr = null)
    {
        $this->targetMinNumOfLFSOnlSolPerCrr = $targetMinNumOfLFSOnlSolPerCrr;
        return $this;
    }
    /**
     * Get targetMinNumOfLFSTotOnlSolPercent value
     * @return \SabreSoap\StructType\TargetMinNumOfLFSTotOnlSolPercent|null
     */
    public function getTargetMinNumOfLFSTotOnlSolPercent()
    {
        return $this->targetMinNumOfLFSTotOnlSolPercent;
    }
    /**
     * Set targetMinNumOfLFSTotOnlSolPercent value
     * @param \SabreSoap\StructType\TargetMinNumOfLFSTotOnlSolPercent $targetMinNumOfLFSTotOnlSolPercent
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setTargetMinNumOfLFSTotOnlSolPercent(\SabreSoap\StructType\TargetMinNumOfLFSTotOnlSolPercent $targetMinNumOfLFSTotOnlSolPercent = null)
    {
        $this->targetMinNumOfLFSTotOnlSolPercent = $targetMinNumOfLFSTotOnlSolPercent;
        return $this;
    }
    /**
     * Get fltOptLFSReuseLimitForNonAVS value
     * @return \SabreSoap\StructType\FltOptLFSReuseLimitForNonAVS|null
     */
    public function getFltOptLFSReuseLimitForNonAVS()
    {
        return $this->fltOptLFSReuseLimitForNonAVS;
    }
    /**
     * Set fltOptLFSReuseLimitForNonAVS value
     * @param \SabreSoap\StructType\FltOptLFSReuseLimitForNonAVS $fltOptLFSReuseLimitForNonAVS
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFltOptLFSReuseLimitForNonAVS(\SabreSoap\StructType\FltOptLFSReuseLimitForNonAVS $fltOptLFSReuseLimitForNonAVS = null)
    {
        $this->fltOptLFSReuseLimitForNonAVS = $fltOptLFSReuseLimitForNonAVS;
        return $this;
    }
    /**
     * Get fltOptLFSReuseLimitForAVS value
     * @return \SabreSoap\StructType\FltOptLFSReuseLimitForAVS|null
     */
    public function getFltOptLFSReuseLimitForAVS()
    {
        return $this->fltOptLFSReuseLimitForAVS;
    }
    /**
     * Set fltOptLFSReuseLimitForAVS value
     * @param \SabreSoap\StructType\FltOptLFSReuseLimitForAVS $fltOptLFSReuseLimitForAVS
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFltOptLFSReuseLimitForAVS(\SabreSoap\StructType\FltOptLFSReuseLimitForAVS $fltOptLFSReuseLimitForAVS = null)
    {
        $this->fltOptLFSReuseLimitForAVS = $fltOptLFSReuseLimitForAVS;
        return $this;
    }
    /**
     * Get avsPenaltyCrrs value
     * @return \SabreSoap\StructType\AvsPenaltyCrrs|null
     */
    public function getAvsPenaltyCrrs()
    {
        return $this->avsPenaltyCrrs;
    }
    /**
     * Set avsPenaltyCrrs value
     * @param \SabreSoap\StructType\AvsPenaltyCrrs $avsPenaltyCrrs
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAvsPenaltyCrrs(\SabreSoap\StructType\AvsPenaltyCrrs $avsPenaltyCrrs = null)
    {
        $this->avsPenaltyCrrs = $avsPenaltyCrrs;
        return $this;
    }
    /**
     * Get maxNumOfNonStpOnlSol value
     * @return \SabreSoap\StructType\MaxNumOfNonStpOnlSol|null
     */
    public function getMaxNumOfNonStpOnlSol()
    {
        return $this->maxNumOfNonStpOnlSol;
    }
    /**
     * Set maxNumOfNonStpOnlSol value
     * @param \SabreSoap\StructType\MaxNumOfNonStpOnlSol $maxNumOfNonStpOnlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxNumOfNonStpOnlSol(\SabreSoap\StructType\MaxNumOfNonStpOnlSol $maxNumOfNonStpOnlSol = null)
    {
        $this->maxNumOfNonStpOnlSol = $maxNumOfNonStpOnlSol;
        return $this;
    }
    /**
     * Get maxNumOfNonStpInrlSol value
     * @return \SabreSoap\StructType\MaxNumOfNonStpInrlSol|null
     */
    public function getMaxNumOfNonStpInrlSol()
    {
        return $this->maxNumOfNonStpInrlSol;
    }
    /**
     * Set maxNumOfNonStpInrlSol value
     * @param \SabreSoap\StructType\MaxNumOfNonStpInrlSol $maxNumOfNonStpInrlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxNumOfNonStpInrlSol(\SabreSoap\StructType\MaxNumOfNonStpInrlSol $maxNumOfNonStpInrlSol = null)
    {
        $this->maxNumOfNonStpInrlSol = $maxNumOfNonStpInrlSol;
        return $this;
    }
    /**
     * Get maxNumOfSingleStpOnlSol value
     * @return \SabreSoap\StructType\MaxNumOfSingleStpOnlSol|null
     */
    public function getMaxNumOfSingleStpOnlSol()
    {
        return $this->maxNumOfSingleStpOnlSol;
    }
    /**
     * Set maxNumOfSingleStpOnlSol value
     * @param \SabreSoap\StructType\MaxNumOfSingleStpOnlSol $maxNumOfSingleStpOnlSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxNumOfSingleStpOnlSol(\SabreSoap\StructType\MaxNumOfSingleStpOnlSol $maxNumOfSingleStpOnlSol = null)
    {
        $this->maxNumOfSingleStpOnlSol = $maxNumOfSingleStpOnlSol;
        return $this;
    }
    /**
     * Get maxNumOf2PlusStpSol value
     * @return \SabreSoap\StructType\MaxNumOf2PlusStpSol|null
     */
    public function getMaxNumOf2PlusStpSol()
    {
        return $this->maxNumOf2PlusStpSol;
    }
    /**
     * Set maxNumOf2PlusStpSol value
     * @param \SabreSoap\StructType\MaxNumOf2PlusStpSol $maxNumOf2PlusStpSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxNumOf2PlusStpSol(\SabreSoap\StructType\MaxNumOf2PlusStpSol $maxNumOf2PlusStpSol = null)
    {
        $this->maxNumOf2PlusStpSol = $maxNumOf2PlusStpSol;
        return $this;
    }
    /**
     * Get minAllowedOveragePerCrrPercent value
     * @return \SabreSoap\StructType\MinAllowedOveragePerCrrPercent|null
     */
    public function getMinAllowedOveragePerCrrPercent()
    {
        return $this->minAllowedOveragePerCrrPercent;
    }
    /**
     * Set minAllowedOveragePerCrrPercent value
     * @param \SabreSoap\StructType\MinAllowedOveragePerCrrPercent $minAllowedOveragePerCrrPercent
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMinAllowedOveragePerCrrPercent(\SabreSoap\StructType\MinAllowedOveragePerCrrPercent $minAllowedOveragePerCrrPercent = null)
    {
        $this->minAllowedOveragePerCrrPercent = $minAllowedOveragePerCrrPercent;
        return $this;
    }
    /**
     * Get minAllowedOveragePerCrr value
     * @return \SabreSoap\StructType\MinAllowedOveragePerCrr|null
     */
    public function getMinAllowedOveragePerCrr()
    {
        return $this->minAllowedOveragePerCrr;
    }
    /**
     * Set minAllowedOveragePerCrr value
     * @param \SabreSoap\StructType\MinAllowedOveragePerCrr $minAllowedOveragePerCrr
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMinAllowedOveragePerCrr(\SabreSoap\StructType\MinAllowedOveragePerCrr $minAllowedOveragePerCrr = null)
    {
        $this->minAllowedOveragePerCrr = $minAllowedOveragePerCrr;
        return $this;
    }
    /**
     * Get maxRelFareLvlOfxForNonStp value
     * @return \SabreSoap\StructType\MaxRelFareLvlOfxForNonStp|null
     */
    public function getMaxRelFareLvlOfxForNonStp()
    {
        return $this->maxRelFareLvlOfxForNonStp;
    }
    /**
     * Set maxRelFareLvlOfxForNonStp value
     * @param \SabreSoap\StructType\MaxRelFareLvlOfxForNonStp $maxRelFareLvlOfxForNonStp
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxRelFareLvlOfxForNonStp(\SabreSoap\StructType\MaxRelFareLvlOfxForNonStp $maxRelFareLvlOfxForNonStp = null)
    {
        $this->maxRelFareLvlOfxForNonStp = $maxRelFareLvlOfxForNonStp;
        return $this;
    }
    /**
     * Get maxRelFareLvlOfxForCnx value
     * @return \SabreSoap\StructType\MaxRelFareLvlOfxForCnx|null
     */
    public function getMaxRelFareLvlOfxForCnx()
    {
        return $this->maxRelFareLvlOfxForCnx;
    }
    /**
     * Set maxRelFareLvlOfxForCnx value
     * @param \SabreSoap\StructType\MaxRelFareLvlOfxForCnx $maxRelFareLvlOfxForCnx
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMaxRelFareLvlOfxForCnx(\SabreSoap\StructType\MaxRelFareLvlOfxForCnx $maxRelFareLvlOfxForCnx = null)
    {
        $this->maxRelFareLvlOfxForCnx = $maxRelFareLvlOfxForCnx;
        return $this;
    }
    /**
     * Get numOfMustPrice2PlusStpSol value
     * @return \SabreSoap\StructType\NumOfMustPrice2PlusStpSol|null
     */
    public function getNumOfMustPrice2PlusStpSol()
    {
        return $this->numOfMustPrice2PlusStpSol;
    }
    /**
     * Set numOfMustPrice2PlusStpSol value
     * @param \SabreSoap\StructType\NumOfMustPrice2PlusStpSol $numOfMustPrice2PlusStpSol
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setNumOfMustPrice2PlusStpSol(\SabreSoap\StructType\NumOfMustPrice2PlusStpSol $numOfMustPrice2PlusStpSol = null)
    {
        $this->numOfMustPrice2PlusStpSol = $numOfMustPrice2PlusStpSol;
        return $this;
    }
    /**
     * Get ItineraryNumberThreshold value
     * @return \SabreSoap\StructType\ItineraryNumberThreshold|null
     */
    public function getItineraryNumberThreshold()
    {
        return $this->ItineraryNumberThreshold;
    }
    /**
     * Set ItineraryNumberThreshold value
     * @param \SabreSoap\StructType\ItineraryNumberThreshold $itineraryNumberThreshold
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setItineraryNumberThreshold(\SabreSoap\StructType\ItineraryNumberThreshold $itineraryNumberThreshold = null)
    {
        $this->ItineraryNumberThreshold = $itineraryNumberThreshold;
        return $this;
    }
    /**
     * Get XOFares value
     * @return \SabreSoap\StructType\XOFaresType|null
     */
    public function getXOFares()
    {
        return $this->XOFares;
    }
    /**
     * Set XOFares value
     * @param \SabreSoap\StructType\XOFaresType $xOFares
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setXOFares(\SabreSoap\StructType\XOFaresType $xOFares = null)
    {
        $this->XOFares = $xOFares;
        return $this;
    }
    /**
     * Get ExemptAllTaxes value
     * @return \SabreSoap\StructType\ExemptAllTaxes|null
     */
    public function getExemptAllTaxes()
    {
        return $this->ExemptAllTaxes;
    }
    /**
     * Set ExemptAllTaxes value
     * @param \SabreSoap\StructType\ExemptAllTaxes $exemptAllTaxes
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setExemptAllTaxes(\SabreSoap\StructType\ExemptAllTaxes $exemptAllTaxes = null)
    {
        $this->ExemptAllTaxes = $exemptAllTaxes;
        return $this;
    }
    /**
     * Get ExemptAllTaxesAndFees value
     * @return \SabreSoap\StructType\ExemptAllTaxesAndFees|null
     */
    public function getExemptAllTaxesAndFees()
    {
        return $this->ExemptAllTaxesAndFees;
    }
    /**
     * Set ExemptAllTaxesAndFees value
     * @param \SabreSoap\StructType\ExemptAllTaxesAndFees $exemptAllTaxesAndFees
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setExemptAllTaxesAndFees(\SabreSoap\StructType\ExemptAllTaxesAndFees $exemptAllTaxesAndFees = null)
    {
        $this->ExemptAllTaxesAndFees = $exemptAllTaxesAndFees;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \SabreSoap\StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \SabreSoap\StructType\Taxes $taxes
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setTaxes(\SabreSoap\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get ExemptTax value
     * @return \SabreSoap\StructType\TaxCodeType|null
     */
    public function getExemptTax()
    {
        return $this->ExemptTax;
    }
    /**
     * Set ExemptTax value
     * @param \SabreSoap\StructType\TaxCodeType $exemptTax
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setExemptTax(\SabreSoap\StructType\TaxCodeType $exemptTax = null)
    {
        $this->ExemptTax = $exemptTax;
        return $this;
    }
    /**
     * Get FlightStopsAsConnections value
     * @return \SabreSoap\StructType\FlightStopsAsConnectionsType|null
     */
    public function getFlightStopsAsConnections()
    {
        return $this->FlightStopsAsConnections;
    }
    /**
     * Set FlightStopsAsConnections value
     * @param \SabreSoap\StructType\FlightStopsAsConnectionsType $flightStopsAsConnections
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFlightStopsAsConnections(\SabreSoap\StructType\FlightStopsAsConnectionsType $flightStopsAsConnections = null)
    {
        $this->FlightStopsAsConnections = $flightStopsAsConnections;
        return $this;
    }
    /**
     * Get TicketingSumOfLocals value
     * @return \SabreSoap\StructType\TicketingSumOfLocals|null
     */
    public function getTicketingSumOfLocals()
    {
        return $this->TicketingSumOfLocals;
    }
    /**
     * Set TicketingSumOfLocals value
     * @param \SabreSoap\StructType\TicketingSumOfLocals $ticketingSumOfLocals
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setTicketingSumOfLocals(\SabreSoap\StructType\TicketingSumOfLocals $ticketingSumOfLocals = null)
    {
        $this->TicketingSumOfLocals = $ticketingSumOfLocals;
        return $this;
    }
    /**
     * Get JumpCabinLogic value
     * @return \SabreSoap\StructType\JumpCabinLogicType|null
     */
    public function getJumpCabinLogic()
    {
        return $this->JumpCabinLogic;
    }
    /**
     * Set JumpCabinLogic value
     * @param \SabreSoap\StructType\JumpCabinLogicType $jumpCabinLogic
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setJumpCabinLogic(\SabreSoap\StructType\JumpCabinLogicType $jumpCabinLogic = null)
    {
        $this->JumpCabinLogic = $jumpCabinLogic;
        return $this;
    }
    /**
     * Get GoverningCarrierOverride value
     * @return \SabreSoap\StructType\GoverningCarrierOverrideType|null
     */
    public function getGoverningCarrierOverride()
    {
        return $this->GoverningCarrierOverride;
    }
    /**
     * Set GoverningCarrierOverride value
     * @param \SabreSoap\StructType\GoverningCarrierOverrideType $governingCarrierOverride
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setGoverningCarrierOverride(\SabreSoap\StructType\GoverningCarrierOverrideType $governingCarrierOverride = null)
    {
        $this->GoverningCarrierOverride = $governingCarrierOverride;
        return $this;
    }
    /**
     * Get ExcludeCallDirectCarriers value
     * @return \SabreSoap\StructType\ExcludeCallDirectCarriers|null
     */
    public function getExcludeCallDirectCarriers()
    {
        return $this->ExcludeCallDirectCarriers;
    }
    /**
     * Set ExcludeCallDirectCarriers value
     * @param \SabreSoap\StructType\ExcludeCallDirectCarriers $excludeCallDirectCarriers
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setExcludeCallDirectCarriers(\SabreSoap\StructType\ExcludeCallDirectCarriers $excludeCallDirectCarriers = null)
    {
        $this->ExcludeCallDirectCarriers = $excludeCallDirectCarriers;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \SabreSoap\StructType\ValidatingCarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \SabreSoap\StructType\ValidatingCarrierType $validatingCarrier
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setValidatingCarrier(\SabreSoap\StructType\ValidatingCarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get SettlementMethod value
     * @return string|null
     */
    public function getSettlementMethod()
    {
        return $this->SettlementMethod;
    }
    /**
     * Set SettlementMethod value
     * @param string $settlementMethod
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSettlementMethod($settlementMethod = null)
    {
        $this->SettlementMethod = $settlementMethod;
        return $this;
    }
    /**
     * Get FlexibleFares value
     * @return \SabreSoap\StructType\FlexibleFaresType|null
     */
    public function getFlexibleFares()
    {
        return $this->FlexibleFares;
    }
    /**
     * Set FlexibleFares value
     * @param \SabreSoap\StructType\FlexibleFaresType $flexibleFares
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFlexibleFares(\SabreSoap\StructType\FlexibleFaresType $flexibleFares = null)
    {
        $this->FlexibleFares = $flexibleFares;
        return $this;
    }
    /**
     * Get DiversityParameters value
     * @return \SabreSoap\StructType\DiversityParameters|null
     */
    public function getDiversityParameters()
    {
        return $this->DiversityParameters;
    }
    /**
     * Set DiversityParameters value
     * @param \SabreSoap\StructType\DiversityParameters $diversityParameters
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDiversityParameters(\SabreSoap\StructType\DiversityParameters $diversityParameters = null)
    {
        $this->DiversityParameters = $diversityParameters;
        return $this;
    }
    /**
     * Get AdditionalFareLimit value
     * @return \SabreSoap\StructType\AdditionalFareLimit|null
     */
    public function getAdditionalFareLimit()
    {
        return $this->AdditionalFareLimit;
    }
    /**
     * Set AdditionalFareLimit value
     * @param \SabreSoap\StructType\AdditionalFareLimit $additionalFareLimit
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAdditionalFareLimit(\SabreSoap\StructType\AdditionalFareLimit $additionalFareLimit = null)
    {
        $this->AdditionalFareLimit = $additionalFareLimit;
        return $this;
    }
    /**
     * Get OptionsPerDatePairList value
     * @return \SabreSoap\StructType\OptionsPerDatePairList|null
     */
    public function getOptionsPerDatePairList()
    {
        return $this->OptionsPerDatePairList;
    }
    /**
     * Set OptionsPerDatePairList value
     * @param \SabreSoap\StructType\OptionsPerDatePairList $optionsPerDatePairList
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setOptionsPerDatePairList(\SabreSoap\StructType\OptionsPerDatePairList $optionsPerDatePairList = null)
    {
        $this->OptionsPerDatePairList = $optionsPerDatePairList;
        return $this;
    }
    /**
     * Get ProcessingMessage value
     * @return \SabreSoap\StructType\ComplexProcessingMessageType[]|null
     */
    public function getProcessingMessage()
    {
        return $this->ProcessingMessage;
    }
    /**
     * Set ProcessingMessage value
     * @param \SabreSoap\StructType\ComplexProcessingMessageType[] $processingMessage
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setProcessingMessage(array $processingMessage = array())
    {
        $this->ProcessingMessage = $processingMessage;
        return $this;
    }
    /**
     * Add item to ProcessingMessage value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ComplexProcessingMessageType $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToProcessingMessage(\SabreSoap\StructType\ComplexProcessingMessageType $item)
    {
        $this->ProcessingMessage[] = $item;
        return $this;
    }
    /**
     * Get AirlineOrderList value
     * @return \SabreSoap\StructType\AirlineOrderList|null
     */
    public function getAirlineOrderList()
    {
        return $this->AirlineOrderList;
    }
    /**
     * Set AirlineOrderList value
     * @param \SabreSoap\StructType\AirlineOrderList $airlineOrderList
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAirlineOrderList(\SabreSoap\StructType\AirlineOrderList $airlineOrderList = null)
    {
        $this->AirlineOrderList = $airlineOrderList;
        return $this;
    }
    /**
     * Get SeatsRemaining value
     * @return \SabreSoap\StructType\SeatsRemaining|null
     */
    public function getSeatsRemaining()
    {
        return $this->SeatsRemaining;
    }
    /**
     * Set SeatsRemaining value
     * @param \SabreSoap\StructType\SeatsRemaining $seatsRemaining
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSeatsRemaining(\SabreSoap\StructType\SeatsRemaining $seatsRemaining = null)
    {
        $this->SeatsRemaining = $seatsRemaining;
        return $this;
    }
    /**
     * Get Cabin value
     * @return \SabreSoap\StructType\Cabin|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param \SabreSoap\StructType\Cabin $cabin
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setCabin(\SabreSoap\StructType\Cabin $cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get FareNote value
     * @return \SabreSoap\StructType\FareNote[]|null
     */
    public function getFareNote()
    {
        return $this->FareNote;
    }
    /**
     * Set FareNote value
     * @param \SabreSoap\StructType\FareNote[] $fareNote
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFareNote(array $fareNote = array())
    {
        $this->FareNote = $fareNote;
        return $this;
    }
    /**
     * Add item to FareNote value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\FareNote $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToFareNote(\SabreSoap\StructType\FareNote $item)
    {
        $this->FareNote[] = $item;
        return $this;
    }
    /**
     * Get Meal value
     * @return \SabreSoap\StructType\Meal|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @param \SabreSoap\StructType\Meal $meal
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMeal(\SabreSoap\StructType\Meal $meal = null)
    {
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Get Rule value
     * @return \SabreSoap\StructType\Rule[]|null
     */
    public function getRule()
    {
        return $this->Rule;
    }
    /**
     * Set Rule value
     * @param \SabreSoap\StructType\Rule[] $rule
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setRule(array $rule = array())
    {
        $this->Rule = $rule;
        return $this;
    }
    /**
     * Add item to Rule value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Rule $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToRule(\SabreSoap\StructType\Rule $item)
    {
        $this->Rule[] = $item;
        return $this;
    }
    /**
     * Get DivideInParty value
     * @return \SabreSoap\StructType\DivideInParty|null
     */
    public function getDivideInParty()
    {
        return $this->DivideInParty;
    }
    /**
     * Set DivideInParty value
     * @param \SabreSoap\StructType\DivideInParty $divideInParty
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDivideInParty(\SabreSoap\StructType\DivideInParty $divideInParty = null)
    {
        $this->DivideInParty = $divideInParty;
        return $this;
    }
    /**
     * Get PromoOffer value
     * @return \SabreSoap\StructType\PromoOffer|null
     */
    public function getPromoOffer()
    {
        return $this->PromoOffer;
    }
    /**
     * Set PromoOffer value
     * @param \SabreSoap\StructType\PromoOffer $promoOffer
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPromoOffer(\SabreSoap\StructType\PromoOffer $promoOffer = null)
    {
        $this->PromoOffer = $promoOffer;
        return $this;
    }
    /**
     * Get PromoRedemption value
     * @return \SabreSoap\StructType\PromoRedemption|null
     */
    public function getPromoRedemption()
    {
        return $this->PromoRedemption;
    }
    /**
     * Set PromoRedemption value
     * @param \SabreSoap\StructType\PromoRedemption $promoRedemption
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setPromoRedemption(\SabreSoap\StructType\PromoRedemption $promoRedemption = null)
    {
        $this->PromoRedemption = $promoRedemption;
        return $this;
    }
    /**
     * Get AncillaryFeeGroups value
     * @return \SabreSoap\StructType\AncillaryFeeGroups|null
     */
    public function getAncillaryFeeGroups()
    {
        return $this->AncillaryFeeGroups;
    }
    /**
     * Set AncillaryFeeGroups value
     * @param \SabreSoap\StructType\AncillaryFeeGroups $ancillaryFeeGroups
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAncillaryFeeGroups(\SabreSoap\StructType\AncillaryFeeGroups $ancillaryFeeGroups = null)
    {
        $this->AncillaryFeeGroups = $ancillaryFeeGroups;
        return $this;
    }
    /**
     * Get Legs value
     * @return \SabreSoap\StructType\Legs|null
     */
    public function getLegs()
    {
        return $this->Legs;
    }
    /**
     * Set Legs value
     * @param \SabreSoap\StructType\Legs $legs
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setLegs(\SabreSoap\StructType\Legs $legs = null)
    {
        $this->Legs = $legs;
        return $this;
    }
    /**
     * Get UnflownPrice value
     * @return \SabreSoap\StructType\UnflownPriceType|null
     */
    public function getUnflownPrice()
    {
        return $this->UnflownPrice;
    }
    /**
     * Set UnflownPrice value
     * @param \SabreSoap\StructType\UnflownPriceType $unflownPrice
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setUnflownPrice(\SabreSoap\StructType\UnflownPriceType $unflownPrice = null)
    {
        $this->UnflownPrice = $unflownPrice;
        return $this;
    }
    /**
     * Get eTicket value
     * @return \SabreSoap\StructType\ETicket|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param \SabreSoap\StructType\ETicket $eTicket
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setETicket(\SabreSoap\StructType\ETicket $eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get DataElement value
     * @return \SabreSoap\StructType\DataElement|null
     */
    public function getDataElement()
    {
        return $this->DataElement;
    }
    /**
     * Set DataElement value
     * @param \SabreSoap\StructType\DataElement $dataElement
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDataElement(\SabreSoap\StructType\DataElement $dataElement = null)
    {
        $this->DataElement = $dataElement;
        return $this;
    }
    /**
     * Get Message value
     * @return \SabreSoap\StructType\Message|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \SabreSoap\StructType\Message $message
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMessage(\SabreSoap\StructType\Message $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \SabreSoap\StructType\SurchargesType[]|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @param \SabreSoap\StructType\SurchargesType[] $surcharges
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setSurcharges(array $surcharges = array())
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
    /**
     * Add item to Surcharges value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\SurchargesType $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToSurcharges(\SabreSoap\StructType\SurchargesType $item)
    {
        $this->Surcharges[] = $item;
        return $this;
    }
    /**
     * Get FareComponents value
     * @return \SabreSoap\StructType\FareComponents|null
     */
    public function getFareComponents()
    {
        return $this->FareComponents;
    }
    /**
     * Set FareComponents value
     * @param \SabreSoap\StructType\FareComponents $fareComponents
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFareComponents(\SabreSoap\StructType\FareComponents $fareComponents = null)
    {
        $this->FareComponents = $fareComponents;
        return $this;
    }
    /**
     * Get Messages value
     * @return \SabreSoap\StructType\FareMessagesType|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \SabreSoap\StructType\FareMessagesType $messages
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setMessages(\SabreSoap\StructType\FareMessagesType $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
    /**
     * Get BaggageInformationList value
     * @return \SabreSoap\StructType\BaggageInformationListType|null
     */
    public function getBaggageInformationList()
    {
        return $this->BaggageInformationList;
    }
    /**
     * Set BaggageInformationList value
     * @param \SabreSoap\StructType\BaggageInformationListType $baggageInformationList
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setBaggageInformationList(\SabreSoap\StructType\BaggageInformationListType $baggageInformationList = null)
    {
        $this->BaggageInformationList = $baggageInformationList;
        return $this;
    }
    /**
     * Get FareCalcLine value
     * @return \SabreSoap\StructType\FareCalcLineType|null
     */
    public function getFareCalcLine()
    {
        return $this->FareCalcLine;
    }
    /**
     * Set FareCalcLine value
     * @param \SabreSoap\StructType\FareCalcLineType $fareCalcLine
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFareCalcLine(\SabreSoap\StructType\FareCalcLineType $fareCalcLine = null)
    {
        $this->FareCalcLine = $fareCalcLine;
        return $this;
    }
    /**
     * Get FareType value
     * @return \SabreSoap\StructType\FareType|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param \SabreSoap\StructType\FareType $fareType
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setFareType(\SabreSoap\StructType\FareType $fareType = null)
    {
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get AdditionalFares value
     * @return \SabreSoap\StructType\AdditionalFares[]|null
     */
    public function getAdditionalFares()
    {
        return $this->AdditionalFares;
    }
    /**
     * Set AdditionalFares value
     * @param \SabreSoap\StructType\AdditionalFares[] $additionalFares
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setAdditionalFares(array $additionalFares = array())
    {
        $this->AdditionalFares = $additionalFares;
        return $this;
    }
    /**
     * Add item to AdditionalFares value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AdditionalFares $item
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function addToAdditionalFares(\SabreSoap\StructType\AdditionalFares $item)
    {
        $this->AdditionalFares[] = $item;
        return $this;
    }
    /**
     * Get Ops value
     * @return \SabreSoap\StructType\Ops|null
     */
    public function getOps()
    {
        return $this->Ops;
    }
    /**
     * Set Ops value
     * @param \SabreSoap\StructType\Ops $ops
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setOps(\SabreSoap\StructType\Ops $ops = null)
    {
        $this->Ops = $ops;
        return $this;
    }
    /**
     * Get ItinSource value
     * @return \SabreSoap\StructType\ItinSource|null
     */
    public function getItinSource()
    {
        return $this->ItinSource;
    }
    /**
     * Set ItinSource value
     * @param \SabreSoap\StructType\ItinSource $itinSource
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setItinSource(\SabreSoap\StructType\ItinSource $itinSource = null)
    {
        $this->ItinSource = $itinSource;
        return $this;
    }
    /**
     * Get ValueBucket value
     * @return \SabreSoap\StructType\ValueBucket|null
     */
    public function getValueBucket()
    {
        return $this->ValueBucket;
    }
    /**
     * Set ValueBucket value
     * @param \SabreSoap\StructType\ValueBucket $valueBucket
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setValueBucket(\SabreSoap\StructType\ValueBucket $valueBucket = null)
    {
        $this->ValueBucket = $valueBucket;
        return $this;
    }
    /**
     * Get DiversitySwapper value
     * @return \SabreSoap\StructType\DiversitySwapper|null
     */
    public function getDiversitySwapper()
    {
        return $this->DiversitySwapper;
    }
    /**
     * Set DiversitySwapper value
     * @param \SabreSoap\StructType\DiversitySwapper $diversitySwapper
     * @return \SabreSoap\StructType\TPA_Extensions
     */
    public function setDiversitySwapper(\SabreSoap\StructType\DiversitySwapper $diversitySwapper = null)
    {
        $this->DiversitySwapper = $diversitySwapper;
        return $this;
    }
}
