<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureMethodType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class SignatureMethodType extends AbstractStructBase
{
    /**
     * The Algorithm
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Algorithm;
    /**
     * The HMACOutputLength
     * Meta information extracted from the WSDL
     * - base: integer
     * - minOccurs: 0
     * @var int
     */
    public $HMACOutputLength;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SignatureMethodType
     * @uses SignatureMethodType::setAlgorithm()
     * @uses SignatureMethodType::setHMACOutputLength()
     * @uses SignatureMethodType::setAny()
     * @param string $algorithm
     * @param int $hMACOutputLength
     * @param \DOMDocument $any
     */
    public function __construct($algorithm = null, $hMACOutputLength = null, \DOMDocument $any = null)
    {
        $this
            ->setAlgorithm($algorithm)
            ->setHMACOutputLength($hMACOutputLength)
            ->setAny($any);
    }
    /**
     * Get Algorithm value
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }
    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return \SabreSoap\StructType\SignatureMethodType
     */
    public function setAlgorithm($algorithm = null)
    {
        $this->Algorithm = $algorithm;
        return $this;
    }
    /**
     * Get HMACOutputLength value
     * @return int|null
     */
    public function getHMACOutputLength()
    {
        return $this->HMACOutputLength;
    }
    /**
     * Set HMACOutputLength value
     * @param int $hMACOutputLength
     * @return \SabreSoap\StructType\SignatureMethodType
     */
    public function setHMACOutputLength($hMACOutputLength = null)
    {
        $this->HMACOutputLength = $hMACOutputLength;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\SignatureMethodType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
