<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingDuplicate StructType
 * @subpackage Structs
 */
class OperatingDuplicate extends AbstractStructBase
{
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 10
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $Weight;
    /**
     * The PreferredCarrier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PreferredCarrier[]
     */
    public $PreferredCarrier;
    /**
     * Constructor method for OperatingDuplicate
     * @uses OperatingDuplicate::setWeight()
     * @uses OperatingDuplicate::setPreferredCarrier()
     * @param int $weight
     * @param \SabreSoap\StructType\PreferredCarrier[] $preferredCarrier
     */
    public function __construct($weight = null, array $preferredCarrier = array())
    {
        $this
            ->setWeight($weight)
            ->setPreferredCarrier($preferredCarrier);
    }
    /**
     * Get Weight value
     * @return int
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \SabreSoap\StructType\OperatingDuplicate
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get PreferredCarrier value
     * @return \SabreSoap\StructType\PreferredCarrier[]|null
     */
    public function getPreferredCarrier()
    {
        return $this->PreferredCarrier;
    }
    /**
     * Set PreferredCarrier value
     * @param \SabreSoap\StructType\PreferredCarrier[] $preferredCarrier
     * @return \SabreSoap\StructType\OperatingDuplicate
     */
    public function setPreferredCarrier(array $preferredCarrier = array())
    {
        $this->PreferredCarrier = $preferredCarrier;
        return $this;
    }
    /**
     * Add item to PreferredCarrier value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\PreferredCarrier $item
     * @return \SabreSoap\StructType\OperatingDuplicate
     */
    public function addToPreferredCarrier(\SabreSoap\StructType\PreferredCarrier $item)
    {
        $this->PreferredCarrier[] = $item;
        return $this;
    }
}
