<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageOrder StructType
 * @subpackage Structs
 */
class MessageOrder extends AbstractStructBase
{
    /**
     * The SequenceNumber
     * Meta information extracted from the WSDL
     * - ref: tns:SequenceNumber
     * @var \SabreSoap\StructType\SequenceNumber_type
     */
    public $SequenceNumber;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for MessageOrder
     * @uses MessageOrder::setSequenceNumber()
     * @uses MessageOrder::setAny()
     * @uses MessageOrder::setId()
     * @uses MessageOrder::setVersion()
     * @param \SabreSoap\StructType\SequenceNumber_type $sequenceNumber
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct(\SabreSoap\StructType\SequenceNumber_type $sequenceNumber = null, \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setSequenceNumber($sequenceNumber)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get SequenceNumber value
     * @return \SabreSoap\StructType\SequenceNumber_type|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param \SabreSoap\StructType\SequenceNumber_type $sequenceNumber
     * @return \SabreSoap\StructType\MessageOrder
     */
    public function setSequenceNumber(\SabreSoap\StructType\SequenceNumber_type $sequenceNumber = null)
    {
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\MessageOrder
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\MessageOrder
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\MessageOrder
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
}
