<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeFareType StructType
 * @subpackage Structs
 */
class ExchangeFareType extends AbstractStructBase
{
    /**
     * The BaseFareAmount
     * Meta information extracted from the WSDL
     * - documentation: Base fare amount | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: required
     * @var float
     */
    public $BaseFareAmount;
    /**
     * The BaseFareCurrency
     * Meta information extracted from the WSDL
     * - documentation: Base fare currency | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: required
     * @var string
     */
    public $BaseFareCurrency;
    /**
     * The FareCalcCurrency
     * Meta information extracted from the WSDL
     * - documentation: Fare calc currency | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: required
     * @var string
     */
    public $FareCalcCurrency;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: Validating carrier
     * - base: xs:string
     * - pattern: [0-9A-Z]{2,3}
     * - type: CarrierCode
     * - use: optional
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * The ROE
     * Meta information extracted from the WSDL
     * - documentation: Rate of Exchange override (note: doesn't need to be specified if FareCalc currency and BaseFare currency is the same).
     * - type: xs:double
     * - use: optional
     * @var float
     */
    public $ROE;
    /**
     * Constructor method for ExchangeFareType
     * @uses ExchangeFareType::setBaseFareAmount()
     * @uses ExchangeFareType::setBaseFareCurrency()
     * @uses ExchangeFareType::setFareCalcCurrency()
     * @uses ExchangeFareType::setValidatingCarrier()
     * @uses ExchangeFareType::setROE()
     * @param float $baseFareAmount
     * @param string $baseFareCurrency
     * @param string $fareCalcCurrency
     * @param string $validatingCarrier
     * @param float $rOE
     */
    public function __construct($baseFareAmount = null, $baseFareCurrency = null, $fareCalcCurrency = null, $validatingCarrier = null, $rOE = null)
    {
        $this
            ->setBaseFareAmount($baseFareAmount)
            ->setBaseFareCurrency($baseFareCurrency)
            ->setFareCalcCurrency($fareCalcCurrency)
            ->setValidatingCarrier($validatingCarrier)
            ->setROE($rOE);
    }
    /**
     * Get BaseFareAmount value
     * @return float
     */
    public function getBaseFareAmount()
    {
        return $this->BaseFareAmount;
    }
    /**
     * Set BaseFareAmount value
     * @param float $baseFareAmount
     * @return \SabreSoap\StructType\ExchangeFareType
     */
    public function setBaseFareAmount($baseFareAmount = null)
    {
        $this->BaseFareAmount = $baseFareAmount;
        return $this;
    }
    /**
     * Get BaseFareCurrency value
     * @return string
     */
    public function getBaseFareCurrency()
    {
        return $this->BaseFareCurrency;
    }
    /**
     * Set BaseFareCurrency value
     * @param string $baseFareCurrency
     * @return \SabreSoap\StructType\ExchangeFareType
     */
    public function setBaseFareCurrency($baseFareCurrency = null)
    {
        $this->BaseFareCurrency = $baseFareCurrency;
        return $this;
    }
    /**
     * Get FareCalcCurrency value
     * @return string
     */
    public function getFareCalcCurrency()
    {
        return $this->FareCalcCurrency;
    }
    /**
     * Set FareCalcCurrency value
     * @param string $fareCalcCurrency
     * @return \SabreSoap\StructType\ExchangeFareType
     */
    public function setFareCalcCurrency($fareCalcCurrency = null)
    {
        $this->FareCalcCurrency = $fareCalcCurrency;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \SabreSoap\StructType\ExchangeFareType
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get ROE value
     * @return float|null
     */
    public function getROE()
    {
        return $this->ROE;
    }
    /**
     * Set ROE value
     * @param float $rOE
     * @return \SabreSoap\StructType\ExchangeFareType
     */
    public function setROE($rOE = null)
    {
        $this->ROE = $rOE;
        return $this;
    }
}
