<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeFee StructType
 * @subpackage Structs
 */
class ChangeFee extends AbstractStructBase
{
    /**
     * The HighestChangeFee
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $HighestChangeFee;
    /**
     * The ChangeFeeWaived
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ChangeFeeWaived;
    /**
     * The ChangeFeeNotApplicable
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ChangeFeeNotApplicable;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for ChangeFee
     * @uses ChangeFee::setHighestChangeFee()
     * @uses ChangeFee::setChangeFeeWaived()
     * @uses ChangeFee::setChangeFeeNotApplicable()
     * @uses ChangeFee::setAmount()
     * @uses ChangeFee::setCurrencyCode()
     * @uses ChangeFee::setDecimalPlaces()
     * @param bool $highestChangeFee
     * @param bool $changeFeeWaived
     * @param bool $changeFeeNotApplicable
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($highestChangeFee = null, $changeFeeWaived = null, $changeFeeNotApplicable = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setHighestChangeFee($highestChangeFee)
            ->setChangeFeeWaived($changeFeeWaived)
            ->setChangeFeeNotApplicable($changeFeeNotApplicable)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get HighestChangeFee value
     * @return bool|null
     */
    public function getHighestChangeFee()
    {
        return $this->HighestChangeFee;
    }
    /**
     * Set HighestChangeFee value
     * @param bool $highestChangeFee
     * @return \SabreSoap\StructType\ChangeFee
     */
    public function setHighestChangeFee($highestChangeFee = null)
    {
        $this->HighestChangeFee = $highestChangeFee;
        return $this;
    }
    /**
     * Get ChangeFeeWaived value
     * @return bool|null
     */
    public function getChangeFeeWaived()
    {
        return $this->ChangeFeeWaived;
    }
    /**
     * Set ChangeFeeWaived value
     * @param bool $changeFeeWaived
     * @return \SabreSoap\StructType\ChangeFee
     */
    public function setChangeFeeWaived($changeFeeWaived = null)
    {
        $this->ChangeFeeWaived = $changeFeeWaived;
        return $this;
    }
    /**
     * Get ChangeFeeNotApplicable value
     * @return bool|null
     */
    public function getChangeFeeNotApplicable()
    {
        return $this->ChangeFeeNotApplicable;
    }
    /**
     * Set ChangeFeeNotApplicable value
     * @param bool $changeFeeNotApplicable
     * @return \SabreSoap\StructType\ChangeFee
     */
    public function setChangeFeeNotApplicable($changeFeeNotApplicable = null)
    {
        $this->ChangeFeeNotApplicable = $changeFeeNotApplicable;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabreSoap\StructType\ChangeFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabreSoap\StructType\ChangeFee
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \SabreSoap\StructType\ChangeFee
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
}
