<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about baggage
 * @subpackage Structs
 */
class BaggageInformationType extends AbstractStructBase
{
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \SabreSoap\StructType\Segment[]
     */
    public $Segment;
    /**
     * The Allowance
     * @var \SabreSoap\StructType\Allowance
     */
    public $Allowance;
    /**
     * Constructor method for BaggageInformationType
     * @uses BaggageInformationType::setSegment()
     * @uses BaggageInformationType::setAllowance()
     * @param \SabreSoap\StructType\Segment[] $segment
     * @param \SabreSoap\StructType\Allowance $allowance
     */
    public function __construct(array $segment = array(), \SabreSoap\StructType\Allowance $allowance = null)
    {
        $this
            ->setSegment($segment)
            ->setAllowance($allowance);
    }
    /**
     * Get Segment value
     * @return \SabreSoap\StructType\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \SabreSoap\StructType\Segment[] $segment
     * @return \SabreSoap\StructType\BaggageInformationType
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Segment $item
     * @return \SabreSoap\StructType\BaggageInformationType
     */
    public function addToSegment(\SabreSoap\StructType\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Get Allowance value
     * @return \SabreSoap\StructType\Allowance|null
     */
    public function getAllowance()
    {
        return $this->Allowance;
    }
    /**
     * Set Allowance value
     * @param \SabreSoap\StructType\Allowance $allowance
     * @return \SabreSoap\StructType\BaggageInformationType
     */
    public function setAllowance(\SabreSoap\StructType\Allowance $allowance = null)
    {
        $this->Allowance = $allowance;
        return $this;
    }
}
