<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFees StructType
 * @subpackage Structs
 */
class AncillaryFees extends AbstractStructBase
{
    /**
     * The Enable
     * Meta information extracted from the WSDL
     * - documentation: Enable Ancillary Fees processing path.
     * - use: required
     * @var bool
     */
    public $Enable;
    /**
     * The AncillaryFeeGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AncillaryFeeGroup[]
     */
    public $AncillaryFeeGroup;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - documentation: Flag whether this is a summary request.
     * @var bool
     */
    public $Summary;
    /**
     * Constructor method for AncillaryFees
     * @uses AncillaryFees::setEnable()
     * @uses AncillaryFees::setAncillaryFeeGroup()
     * @uses AncillaryFees::setSummary()
     * @param bool $enable
     * @param \SabreSoap\StructType\AncillaryFeeGroup[] $ancillaryFeeGroup
     * @param bool $summary
     */
    public function __construct($enable = null, array $ancillaryFeeGroup = array(), $summary = null)
    {
        $this
            ->setEnable($enable)
            ->setAncillaryFeeGroup($ancillaryFeeGroup)
            ->setSummary($summary);
    }
    /**
     * Get Enable value
     * @return bool
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param bool $enable
     * @return \SabreSoap\StructType\AncillaryFees
     */
    public function setEnable($enable = null)
    {
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Get AncillaryFeeGroup value
     * @return \SabreSoap\StructType\AncillaryFeeGroup[]|null
     */
    public function getAncillaryFeeGroup()
    {
        return $this->AncillaryFeeGroup;
    }
    /**
     * Set AncillaryFeeGroup value
     * @param \SabreSoap\StructType\AncillaryFeeGroup[] $ancillaryFeeGroup
     * @return \SabreSoap\StructType\AncillaryFees
     */
    public function setAncillaryFeeGroup(array $ancillaryFeeGroup = array())
    {
        $this->AncillaryFeeGroup = $ancillaryFeeGroup;
        return $this;
    }
    /**
     * Add item to AncillaryFeeGroup value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AncillaryFeeGroup $item
     * @return \SabreSoap\StructType\AncillaryFees
     */
    public function addToAncillaryFeeGroup(\SabreSoap\StructType\AncillaryFeeGroup $item)
    {
        $this->AncillaryFeeGroup[] = $item;
        return $this;
    }
    /**
     * Get Summary value
     * @return bool|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param bool $summary
     * @return \SabreSoap\StructType\AncillaryFees
     */
    public function setSummary($summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
}
