<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies passenger numbers and types.
 * @subpackage Structs
 */
class TravelerInformationType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta information extracted from the WSDL
     * - documentation: Specifies number of passengers using Passenger Type Codes.
     * - maxOccurs: 9
     * @var \SabreSoap\StructType\PassengerTypeQuantityType[]
     */
    public $PassengerTypeQuantity;
    /**
     * The AirTraveler
     * Meta information extracted from the WSDL
     * - documentation: Information profiling the person traveling Gender - the gender of the customer, if needed BirthDate - Date of Birth Currency - the preferred currency in which monetary amounts should be returned.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirTravelerType
     */
    public $AirTraveler;
    /**
     * Constructor method for TravelerInformationType
     * @uses TravelerInformationType::setPassengerTypeQuantity()
     * @uses TravelerInformationType::setAirTraveler()
     * @param \SabreSoap\StructType\PassengerTypeQuantityType[] $passengerTypeQuantity
     * @param \SabreSoap\StructType\AirTravelerType $airTraveler
     */
    public function __construct(array $passengerTypeQuantity = array(), \SabreSoap\StructType\AirTravelerType $airTraveler = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setAirTraveler($airTraveler);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \SabreSoap\StructType\PassengerTypeQuantityType[]|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \SabreSoap\StructType\PassengerTypeQuantityType[] $passengerTypeQuantity
     * @return \SabreSoap\StructType\TravelerInformationType
     */
    public function setPassengerTypeQuantity(array $passengerTypeQuantity = array())
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Add item to PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\PassengerTypeQuantityType $item
     * @return \SabreSoap\StructType\TravelerInformationType
     */
    public function addToPassengerTypeQuantity(\SabreSoap\StructType\PassengerTypeQuantityType $item)
    {
        $this->PassengerTypeQuantity[] = $item;
        return $this;
    }
    /**
     * Get AirTraveler value
     * @return \SabreSoap\StructType\AirTravelerType|null
     */
    public function getAirTraveler()
    {
        return $this->AirTraveler;
    }
    /**
     * Set AirTraveler value
     * @param \SabreSoap\StructType\AirTravelerType $airTraveler
     * @return \SabreSoap\StructType\TravelerInformationType
     */
    public function setAirTraveler(\SabreSoap\StructType\AirTravelerType $airTraveler = null)
    {
        $this->AirTraveler = $airTraveler;
        return $this;
    }
}
