<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains summary fare rule information as well as detailed Rule Information for Fare Basis Codes. Information may be actual rules data or the results returned from a rules-based inquiry.
 * @subpackage Structs
 */
class RuleInfoType extends AbstractStructBase
{
    /**
     * The ResTicketingRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ResTicketingRules
     */
    public $ResTicketingRules;
    /**
     * The LengthOfStayRules
     * Meta information extracted from the WSDL
     * - documentation: Rules providing minimum or maximum stay restrictions.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\StayRestrictionsType
     */
    public $LengthOfStayRules;
    /**
     * Constructor method for RuleInfoType
     * @uses RuleInfoType::setResTicketingRules()
     * @uses RuleInfoType::setLengthOfStayRules()
     * @param \SabreSoap\StructType\ResTicketingRules $resTicketingRules
     * @param \SabreSoap\StructType\StayRestrictionsType $lengthOfStayRules
     */
    public function __construct(\SabreSoap\StructType\ResTicketingRules $resTicketingRules = null, \SabreSoap\StructType\StayRestrictionsType $lengthOfStayRules = null)
    {
        $this
            ->setResTicketingRules($resTicketingRules)
            ->setLengthOfStayRules($lengthOfStayRules);
    }
    /**
     * Get ResTicketingRules value
     * @return \SabreSoap\StructType\ResTicketingRules|null
     */
    public function getResTicketingRules()
    {
        return $this->ResTicketingRules;
    }
    /**
     * Set ResTicketingRules value
     * @param \SabreSoap\StructType\ResTicketingRules $resTicketingRules
     * @return \SabreSoap\StructType\RuleInfoType
     */
    public function setResTicketingRules(\SabreSoap\StructType\ResTicketingRules $resTicketingRules = null)
    {
        $this->ResTicketingRules = $resTicketingRules;
        return $this;
    }
    /**
     * Get LengthOfStayRules value
     * @return \SabreSoap\StructType\StayRestrictionsType|null
     */
    public function getLengthOfStayRules()
    {
        return $this->LengthOfStayRules;
    }
    /**
     * Set LengthOfStayRules value
     * @param \SabreSoap\StructType\StayRestrictionsType $lengthOfStayRules
     * @return \SabreSoap\StructType\RuleInfoType
     */
    public function setLengthOfStayRules(\SabreSoap\StructType\StayRestrictionsType $lengthOfStayRules = null)
    {
        $this->LengthOfStayRules = $lengthOfStayRules;
        return $this;
    }
}
