<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundOutboundPairing StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the requested ratio of inbounds to outbounds in the response.
 * @subpackage Structs
 */
class InboundOutboundPairing extends AbstractStructBase
{
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 10
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $Weight;
    /**
     * The Duplicates
     * Meta information extracted from the WSDL
     * - default: 1
     * @var int
     */
    public $Duplicates;
    /**
     * Constructor method for InboundOutboundPairing
     * @uses InboundOutboundPairing::setWeight()
     * @uses InboundOutboundPairing::setDuplicates()
     * @param int $weight
     * @param int $duplicates
     */
    public function __construct($weight = null, $duplicates = 1)
    {
        $this
            ->setWeight($weight)
            ->setDuplicates($duplicates);
    }
    /**
     * Get Weight value
     * @return int
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \SabreSoap\StructType\InboundOutboundPairing
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Duplicates value
     * @return int|null
     */
    public function getDuplicates()
    {
        return $this->Duplicates;
    }
    /**
     * Set Duplicates value
     * @param int $duplicates
     * @return \SabreSoap\StructType\InboundOutboundPairing
     */
    public function setDuplicates($duplicates = 1)
    {
        $this->Duplicates = $duplicates;
        return $this;
    }
}
