<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorList StructType
 * @subpackage Structs
 */
class ErrorList extends AbstractStructBase
{
    /**
     * The highestSeverity
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $highestSeverity;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:Error
     * @var \SabreSoap\StructType\Error[]
     */
    public $Error;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for ErrorList
     * @uses ErrorList::setHighestSeverity()
     * @uses ErrorList::setError()
     * @uses ErrorList::setAny()
     * @uses ErrorList::setId()
     * @uses ErrorList::setVersion()
     * @param string $highestSeverity
     * @param \SabreSoap\StructType\Error[] $error
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct($highestSeverity = null, array $error = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setError($error)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get highestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->highestSeverity;
    }
    /**
     * Set highestSeverity value
     * @param string $highestSeverity
     * @return \SabreSoap\StructType\ErrorList
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        $this->highestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Error value
     * @return \SabreSoap\StructType\Error[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \SabreSoap\StructType\Error[] $error
     * @return \SabreSoap\StructType\ErrorList
     */
    public function setError(array $error = array())
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Error $item
     * @return \SabreSoap\StructType\ErrorList
     */
    public function addToError(\SabreSoap\StructType\Error $item)
    {
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\ErrorList
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\ErrorList
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\ErrorList
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
}
