<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rule StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes a rule that was hit.
 * @subpackage Structs
 */
class Rule extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Rule type. For example: "Fare Note Itin", "DRE"
     * @var string
     */
    public $Type;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Rule ID
     * @var int
     */
    public $ID;
    /**
     * Constructor method for Rule
     * @uses Rule::setType()
     * @uses Rule::setID()
     * @param string $type
     * @param int $iD
     */
    public function __construct($type = null, $iD = null)
    {
        $this
            ->setType($type)
            ->setID($iD);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\Rule
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \SabreSoap\StructType\Rule
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
}
