<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirLowFareSearchRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: The Low Fare Search Request message requests priced itinerary options for flights between specific city pairs on specific dates for specific numbers and types of passengers. Optional request information can include: - Time / Time
 * Window - Connecting cities. - Client Preferences (airlines, cabin, flight types etc.) The Low Fare Search request contains similar information to a Low Fare Search entry on an airline CRS or GDS.
 * @subpackage Structs
 */
class OTA_AirLowFareSearchRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: Point of sale object.
     * @var \SabreSoap\StructType\POS_Type
     */
    public $POS;
    /**
     * The OriginDestinationInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OriginDestinationInformation[]
     */
    public $OriginDestinationInformation;
    /**
     * The TravelPreferences
     * Meta information extracted from the WSDL
     * - documentation: Air Low Fare Search Request preference information.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirSearchPrefsType
     */
    public $TravelPreferences;
    /**
     * The TravelerInfoSummary
     * Meta information extracted from the WSDL
     * - documentation: Specifies the number of passengers and types for Air Low Fare Search.
     * @var \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public $TravelerInfoSummary;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The DirectFlightsOnly
     * Meta information extracted from the WSDL
     * - documentation: Request direct flights between given locations. This defaults to false.
     * - default: false
     * - use: optional
     * @var bool
     */
    public $DirectFlightsOnly;
    /**
     * The AvailableFlightsOnly
     * Meta information extracted from the WSDL
     * - documentation: Include only flights with available booking codes (when True or when attribute not present).
     * - default: true
     * - use: optional
     * @var bool
     */
    public $AvailableFlightsOnly;
    /**
     * The ResponseType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseType;
    /**
     * The ResponseVersion
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseVersion;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * Meta information extracted from the WSDL
     * - union: positiveInteger | boolean
     * @var string
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * The MaxResponses
     * @var string
     */
    public $MaxResponses;
    /**
     * Constructor method for OTA_AirLowFareSearchRQ
     * @uses OTA_AirLowFareSearchRQ::setPOS()
     * @uses OTA_AirLowFareSearchRQ::setOriginDestinationInformation()
     * @uses OTA_AirLowFareSearchRQ::setTravelPreferences()
     * @uses OTA_AirLowFareSearchRQ::setTravelerInfoSummary()
     * @uses OTA_AirLowFareSearchRQ::setTPA_Extensions()
     * @uses OTA_AirLowFareSearchRQ::setDirectFlightsOnly()
     * @uses OTA_AirLowFareSearchRQ::setAvailableFlightsOnly()
     * @uses OTA_AirLowFareSearchRQ::setResponseType()
     * @uses OTA_AirLowFareSearchRQ::setResponseVersion()
     * @uses OTA_AirLowFareSearchRQ::setEchoToken()
     * @uses OTA_AirLowFareSearchRQ::setTimeStamp()
     * @uses OTA_AirLowFareSearchRQ::setTarget()
     * @uses OTA_AirLowFareSearchRQ::setVersion()
     * @uses OTA_AirLowFareSearchRQ::setTransactionIdentifier()
     * @uses OTA_AirLowFareSearchRQ::setSequenceNmbr()
     * @uses OTA_AirLowFareSearchRQ::setTransactionStatusCode()
     * @uses OTA_AirLowFareSearchRQ::setPrimaryLangID()
     * @uses OTA_AirLowFareSearchRQ::setAltLangID()
     * @uses OTA_AirLowFareSearchRQ::setMaxResponses()
     * @param \SabreSoap\StructType\POS_Type $pOS
     * @param \SabreSoap\StructType\OriginDestinationInformation[] $originDestinationInformation
     * @param \SabreSoap\StructType\AirSearchPrefsType $travelPreferences
     * @param \SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param bool $directFlightsOnly
     * @param bool $availableFlightsOnly
     * @param string $responseType
     * @param string $responseVersion
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $version
     * @param string $transactionIdentifier
     * @param string $sequenceNmbr
     * @param string $transactionStatusCode
     * @param string $primaryLangID
     * @param string $altLangID
     * @param string $maxResponses
     */
    public function __construct(\SabreSoap\StructType\POS_Type $pOS = null, array $originDestinationInformation = array(), \SabreSoap\StructType\AirSearchPrefsType $travelPreferences = null, \SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $directFlightsOnly = false, $availableFlightsOnly = true, $responseType = null, $responseVersion = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $primaryLangID = null, $altLangID = null, $maxResponses = null)
    {
        $this
            ->setPOS($pOS)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setTravelPreferences($travelPreferences)
            ->setTravelerInfoSummary($travelerInfoSummary)
            ->setTPA_Extensions($tPA_Extensions)
            ->setDirectFlightsOnly($directFlightsOnly)
            ->setAvailableFlightsOnly($availableFlightsOnly)
            ->setResponseType($responseType)
            ->setResponseVersion($responseVersion)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID)
            ->setMaxResponses($maxResponses);
    }
    /**
     * Get POS value
     * @return \SabreSoap\StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \SabreSoap\StructType\POS_Type $pOS
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setPOS(\SabreSoap\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \SabreSoap\StructType\OriginDestinationInformation[]|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @param \SabreSoap\StructType\OriginDestinationInformation[] $originDestinationInformation
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setOriginDestinationInformation(array $originDestinationInformation = array())
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Add item to OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\OriginDestinationInformation $item
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function addToOriginDestinationInformation(\SabreSoap\StructType\OriginDestinationInformation $item)
    {
        $this->OriginDestinationInformation[] = $item;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \SabreSoap\StructType\AirSearchPrefsType|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \SabreSoap\StructType\AirSearchPrefsType $travelPreferences
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setTravelPreferences(\SabreSoap\StructType\AirSearchPrefsType $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Get TravelerInfoSummary value
     * @return \SabreSoap\StructType\TravelerInfoSummaryType|null
     */
    public function getTravelerInfoSummary()
    {
        return $this->TravelerInfoSummary;
    }
    /**
     * Set TravelerInfoSummary value
     * @param \SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setTravelerInfoSummary(\SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary = null)
    {
        $this->TravelerInfoSummary = $travelerInfoSummary;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get DirectFlightsOnly value
     * @return bool|null
     */
    public function getDirectFlightsOnly()
    {
        return $this->DirectFlightsOnly;
    }
    /**
     * Set DirectFlightsOnly value
     * @param bool $directFlightsOnly
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setDirectFlightsOnly($directFlightsOnly = false)
    {
        $this->DirectFlightsOnly = $directFlightsOnly;
        return $this;
    }
    /**
     * Get AvailableFlightsOnly value
     * @return bool|null
     */
    public function getAvailableFlightsOnly()
    {
        return $this->AvailableFlightsOnly;
    }
    /**
     * Set AvailableFlightsOnly value
     * @param bool $availableFlightsOnly
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setAvailableFlightsOnly($availableFlightsOnly = true)
    {
        $this->AvailableFlightsOnly = $availableFlightsOnly;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @param string $responseType
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setResponseType($responseType = null)
    {
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Get ResponseVersion value
     * @return string|null
     */
    public function getResponseVersion()
    {
        return $this->ResponseVersion;
    }
    /**
     * Set ResponseVersion value
     * @param string $responseVersion
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setResponseVersion($responseVersion = null)
    {
        $this->ResponseVersion = $responseVersion;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setEchoToken($echoToken = null)
    {
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setTarget($target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return string|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param string $sequenceNmbr
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setAltLangID($altLangID = null)
    {
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return string|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param string $maxResponses
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        $this->MaxResponses = $maxResponses;
        return $this;
    }
}
