<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelPreferences StructType
 * @subpackage Structs
 */
class TravelPreferences extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\VendorPref[]
     */
    public $VendorPref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * Constructor method for TravelPreferences
     * @uses TravelPreferences::setVendorPref()
     * @uses TravelPreferences::setTPA_Extensions()
     * @param \SabreSoap\StructType\VendorPref[] $vendorPref
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     */
    public function __construct(array $vendorPref = array(), \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get VendorPref value
     * @return \SabreSoap\StructType\VendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @param \SabreSoap\StructType\VendorPref[] $vendorPref
     * @return \SabreSoap\StructType\TravelPreferences
     */
    public function setVendorPref(array $vendorPref = array())
    {
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\VendorPref $item
     * @return \SabreSoap\StructType\TravelPreferences
     */
    public function addToVendorPref(\SabreSoap\StructType\VendorPref $item)
    {
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\TravelPreferences
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
}
