<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelDateTimeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Date and time of trip, that allows specifying a time window before and after the given date.
 * @subpackage Structs
 */
class TravelDateTimeType extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: This date should be of the form YYYY-MM-DDTHH:MM:SS | IntelliSell Date Time type
     * - base: xs:string
     * - choice: DepartureDateTime | ArrivalDateTime | DepartureDates | ArrivalDates
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: This date should be of the form YYYY-MM-DDTHH:MM:SS | IntelliSell Date Time type
     * - base: xs:string
     * - choice: DepartureDateTime | ArrivalDateTime | DepartureDates | ArrivalDates
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The DepartureDates
     * Meta information extracted from the WSDL
     * - choice: DepartureDateTime | ArrivalDateTime | DepartureDates | ArrivalDates
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \SabreSoap\StructType\DepartureDates
     */
    public $DepartureDates;
    /**
     * The ArrivalDates
     * Meta information extracted from the WSDL
     * - choice: DepartureDateTime | ArrivalDateTime | DepartureDates | ArrivalDates
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \SabreSoap\StructType\ArrivalDates
     */
    public $ArrivalDates;
    /**
     * The DepartureWindow
     * Meta information extracted from the WSDL
     * - documentation: This should be of the form HHMMHHMM. | IntelliSell Time Window type in format HHMMHHMM.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: ([0-2][0-9][0-5][0-9]){2}
     * @var string
     */
    public $DepartureWindow;
    /**
     * The ArrivalWindow
     * Meta information extracted from the WSDL
     * - documentation: This should be of the form HHMMHHMM. | IntelliSell Time Window type in format HHMMHHMM.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: ([0-2][0-9][0-5][0-9]){2}
     * @var string
     */
    public $ArrivalWindow;
    /**
     * Constructor method for TravelDateTimeType
     * @uses TravelDateTimeType::setDepartureDateTime()
     * @uses TravelDateTimeType::setArrivalDateTime()
     * @uses TravelDateTimeType::setDepartureDates()
     * @uses TravelDateTimeType::setArrivalDates()
     * @uses TravelDateTimeType::setDepartureWindow()
     * @uses TravelDateTimeType::setArrivalWindow()
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param \SabreSoap\StructType\DepartureDates $departureDates
     * @param \SabreSoap\StructType\ArrivalDates $arrivalDates
     * @param string $departureWindow
     * @param string $arrivalWindow
     */
    public function __construct($departureDateTime = null, $arrivalDateTime = null, \SabreSoap\StructType\DepartureDates $departureDates = null, \SabreSoap\StructType\ArrivalDates $arrivalDates = null, $departureWindow = null, $arrivalWindow = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setDepartureDates($departureDates)
            ->setArrivalDates($arrivalDates)
            ->setDepartureWindow($departureWindow)
            ->setArrivalWindow($arrivalWindow);
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return isset($this->DepartureDateTime) ? $this->DepartureDateTime : null;
    }
    /**
     * Set DepartureDateTime value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $departureDateTime
     * @return \SabreSoap\StructType\TravelDateTimeType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        if (is_null($departureDateTime) || (is_array($departureDateTime) && empty($departureDateTime))) {
            unset($this->DepartureDateTime);
        } else {
            $this->DepartureDateTime = $departureDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return isset($this->ArrivalDateTime) ? $this->ArrivalDateTime : null;
    }
    /**
     * Set ArrivalDateTime value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $arrivalDateTime
     * @return \SabreSoap\StructType\TravelDateTimeType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        if (is_null($arrivalDateTime) || (is_array($arrivalDateTime) && empty($arrivalDateTime))) {
            unset($this->ArrivalDateTime);
        } else {
            $this->ArrivalDateTime = $arrivalDateTime;
        }
        return $this;
    }
    /**
     * Get DepartureDates value
     * @return \SabreSoap\StructType\DepartureDates|null
     */
    public function getDepartureDates()
    {
        return isset($this->DepartureDates) ? $this->DepartureDates : null;
    }
    /**
     * Set DepartureDates value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\DepartureDates $departureDates
     * @return \SabreSoap\StructType\TravelDateTimeType
     */
    public function setDepartureDates(\SabreSoap\StructType\DepartureDates $departureDates = null)
    {
        if (is_null($departureDates) || (is_array($departureDates) && empty($departureDates))) {
            unset($this->DepartureDates);
        } else {
            $this->DepartureDates = $departureDates;
        }
        return $this;
    }
    /**
     * Get ArrivalDates value
     * @return \SabreSoap\StructType\ArrivalDates|null
     */
    public function getArrivalDates()
    {
        return isset($this->ArrivalDates) ? $this->ArrivalDates : null;
    }
    /**
     * Set ArrivalDates value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\ArrivalDates $arrivalDates
     * @return \SabreSoap\StructType\TravelDateTimeType
     */
    public function setArrivalDates(\SabreSoap\StructType\ArrivalDates $arrivalDates = null)
    {
        if (is_null($arrivalDates) || (is_array($arrivalDates) && empty($arrivalDates))) {
            unset($this->ArrivalDates);
        } else {
            $this->ArrivalDates = $arrivalDates;
        }
        return $this;
    }
    /**
     * Get DepartureWindow value
     * @return string|null
     */
    public function getDepartureWindow()
    {
        return $this->DepartureWindow;
    }
    /**
     * Set DepartureWindow value
     * @param string $departureWindow
     * @return \SabreSoap\StructType\TravelDateTimeType
     */
    public function setDepartureWindow($departureWindow = null)
    {
        $this->DepartureWindow = $departureWindow;
        return $this;
    }
    /**
     * Get ArrivalWindow value
     * @return string|null
     */
    public function getArrivalWindow()
    {
        return $this->ArrivalWindow;
    }
    /**
     * Set ArrivalWindow value
     * @param string $arrivalWindow
     * @return \SabreSoap\StructType\TravelDateTimeType
     */
    public function setArrivalWindow($arrivalWindow = null)
    {
        $this->ArrivalWindow = $arrivalWindow;
        return $this;
    }
}
