<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSAKeyValueType StructType
 * @subpackage Structs
 */
class RSAKeyValueType extends AbstractStructBase
{
    /**
     * The Modulus
     * Meta information extracted from the WSDL
     * - base: base64Binary
     * @var string
     */
    public $Modulus;
    /**
     * The Exponent
     * Meta information extracted from the WSDL
     * - base: base64Binary
     * @var string
     */
    public $Exponent;
    /**
     * Constructor method for RSAKeyValueType
     * @uses RSAKeyValueType::setModulus()
     * @uses RSAKeyValueType::setExponent()
     * @param string $modulus
     * @param string $exponent
     */
    public function __construct($modulus = null, $exponent = null)
    {
        $this
            ->setModulus($modulus)
            ->setExponent($exponent);
    }
    /**
     * Get Modulus value
     * @return string|null
     */
    public function getModulus()
    {
        return $this->Modulus;
    }
    /**
     * Set Modulus value
     * @param string $modulus
     * @return \SabreSoap\StructType\RSAKeyValueType
     */
    public function setModulus($modulus = null)
    {
        $this->Modulus = $modulus;
        return $this;
    }
    /**
     * Get Exponent value
     * @return string|null
     */
    public function getExponent()
    {
        return $this->Exponent;
    }
    /**
     * Set Exponent value
     * @param string $exponent
     * @return \SabreSoap\StructType\RSAKeyValueType
     */
    public function setExponent($exponent = null)
    {
        $this->Exponent = $exponent;
        return $this;
    }
}
