<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class ObjectType extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The MimeType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MimeType;
    /**
     * The Encoding
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Encoding;
    /**
     * Constructor method for ObjectType
     * @uses ObjectType::setAny()
     * @uses ObjectType::setId()
     * @uses ObjectType::setMimeType()
     * @uses ObjectType::setEncoding()
     * @param \DOMDocument $any
     * @param string $id
     * @param string $mimeType
     * @param string $encoding
     */
    public function __construct(\DOMDocument $any = null, $id = null, $mimeType = null, $encoding = null)
    {
        $this
            ->setAny($any)
            ->setId($id)
            ->setMimeType($mimeType)
            ->setEncoding($encoding);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\ObjectType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabreSoap\StructType\ObjectType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->MimeType;
    }
    /**
     * Set MimeType value
     * @param string $mimeType
     * @return \SabreSoap\StructType\ObjectType
     */
    public function setMimeType($mimeType = null)
    {
        $this->MimeType = $mimeType;
        return $this;
    }
    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @param string $encoding
     * @return \SabreSoap\StructType\ObjectType
     */
    public function setEncoding($encoding = null)
    {
        $this->Encoding = $encoding;
        return $this;
    }
}
