<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: The preference level for the booking class. | Booking class code and preference level for specifying booking classes preferred/not preferred in a request.
 * @subpackage Structs
 */
class BookingClassPrefType extends AbstractStructBase
{
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Booking class code | Used for an Alpha String, length 2 (for letter codes)
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: required
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * - type: PreferLevelType
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for BookingClassPrefType
     * @uses BookingClassPrefType::setResBookDesigCode()
     * @uses BookingClassPrefType::setPreferLevel()
     * @param string $resBookDesigCode
     * @param string $preferLevel
     */
    public function __construct($resBookDesigCode = null, $preferLevel = 'Preferred')
    {
        $this
            ->setResBookDesigCode($resBookDesigCode)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get ResBookDesigCode value
     * @return string
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \SabreSoap\StructType\BookingClassPrefType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @param string $preferLevel
     * @return \SabreSoap\StructType\BookingClassPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
}
