<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Allowance StructType
 * @subpackage Structs
 */
class Allowance extends AbstractStructBase
{
    /**
     * The Pieces
     * Meta information extracted from the WSDL
     * - documentation: Number of Pieces
     * @var int
     */
    public $Pieces;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - documentation: Weight Limit
     * @var int
     */
    public $Weight;
    /**
     * The Unit
     * @var string
     */
    public $Unit;
    /**
     * Constructor method for Allowance
     * @uses Allowance::setPieces()
     * @uses Allowance::setWeight()
     * @uses Allowance::setUnit()
     * @param int $pieces
     * @param int $weight
     * @param string $unit
     */
    public function __construct($pieces = null, $weight = null, $unit = null)
    {
        $this
            ->setPieces($pieces)
            ->setWeight($weight)
            ->setUnit($unit);
    }
    /**
     * Get Pieces value
     * @return int|null
     */
    public function getPieces()
    {
        return $this->Pieces;
    }
    /**
     * Set Pieces value
     * @param int $pieces
     * @return \SabreSoap\StructType\Allowance
     */
    public function setPieces($pieces = null)
    {
        $this->Pieces = $pieces;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \SabreSoap\StructType\Allowance
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \SabreSoap\StructType\Allowance
     */
    public function setUnit($unit = null)
    {
        $this->Unit = $unit;
        return $this;
    }
}
