<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayRestrictionsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining Min and Max Stay Restrictions.
 * @subpackage Structs
 */
class StayRestrictionsType extends AbstractStructBase
{
    /**
     * The MinimumStay
     * @var \SabreSoap\StructType\MinimumStay
     */
    public $MinimumStay;
    /**
     * The MaximumStay
     * @var \SabreSoap\StructType\MaximumStay
     */
    public $MaximumStay;
    /**
     * The StayRestrictionsInd
     * Meta information extracted from the WSDL
     * - documentation: True indicates that Stay Restrictions exist.
     * - use: optional
     * @var bool
     */
    public $StayRestrictionsInd;
    /**
     * Constructor method for StayRestrictionsType
     * @uses StayRestrictionsType::setMinimumStay()
     * @uses StayRestrictionsType::setMaximumStay()
     * @uses StayRestrictionsType::setStayRestrictionsInd()
     * @param \SabreSoap\StructType\MinimumStay $minimumStay
     * @param \SabreSoap\StructType\MaximumStay $maximumStay
     * @param bool $stayRestrictionsInd
     */
    public function __construct(\SabreSoap\StructType\MinimumStay $minimumStay = null, \SabreSoap\StructType\MaximumStay $maximumStay = null, $stayRestrictionsInd = null)
    {
        $this
            ->setMinimumStay($minimumStay)
            ->setMaximumStay($maximumStay)
            ->setStayRestrictionsInd($stayRestrictionsInd);
    }
    /**
     * Get MinimumStay value
     * @return \SabreSoap\StructType\MinimumStay|null
     */
    public function getMinimumStay()
    {
        return $this->MinimumStay;
    }
    /**
     * Set MinimumStay value
     * @param \SabreSoap\StructType\MinimumStay $minimumStay
     * @return \SabreSoap\StructType\StayRestrictionsType
     */
    public function setMinimumStay(\SabreSoap\StructType\MinimumStay $minimumStay = null)
    {
        $this->MinimumStay = $minimumStay;
        return $this;
    }
    /**
     * Get MaximumStay value
     * @return \SabreSoap\StructType\MaximumStay|null
     */
    public function getMaximumStay()
    {
        return $this->MaximumStay;
    }
    /**
     * Set MaximumStay value
     * @param \SabreSoap\StructType\MaximumStay $maximumStay
     * @return \SabreSoap\StructType\StayRestrictionsType
     */
    public function setMaximumStay(\SabreSoap\StructType\MaximumStay $maximumStay = null)
    {
        $this->MaximumStay = $maximumStay;
        return $this;
    }
    /**
     * Get StayRestrictionsInd value
     * @return bool|null
     */
    public function getStayRestrictionsInd()
    {
        return $this->StayRestrictionsInd;
    }
    /**
     * Set StayRestrictionsInd value
     * @param bool $stayRestrictionsInd
     * @return \SabreSoap\StructType\StayRestrictionsType
     */
    public function setStayRestrictionsInd($stayRestrictionsInd = null)
    {
        $this->StayRestrictionsInd = $stayRestrictionsInd;
        return $this;
    }
}
