<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightTypePrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates preferences for certain types of flights, such as connections or stopovers, when used for a specific travel situation.
 * @subpackage Structs
 */
class FlightTypePrefType extends AbstractStructBase
{
    /**
     * The FlightType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FlightType;
    /**
     * The MaxConnections
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MaxConnections;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * - type: PreferLevelType
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for FlightTypePrefType
     * @uses FlightTypePrefType::setFlightType()
     * @uses FlightTypePrefType::setMaxConnections()
     * @uses FlightTypePrefType::setPreferLevel()
     * @param string $flightType
     * @param string $maxConnections
     * @param string $preferLevel
     */
    public function __construct($flightType = null, $maxConnections = null, $preferLevel = 'Preferred')
    {
        $this
            ->setFlightType($flightType)
            ->setMaxConnections($maxConnections)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get FlightType value
     * @return string|null
     */
    public function getFlightType()
    {
        return $this->FlightType;
    }
    /**
     * Set FlightType value
     * @param string $flightType
     * @return \SabreSoap\StructType\FlightTypePrefType
     */
    public function setFlightType($flightType = null)
    {
        $this->FlightType = $flightType;
        return $this;
    }
    /**
     * Get MaxConnections value
     * @return string|null
     */
    public function getMaxConnections()
    {
        return $this->MaxConnections;
    }
    /**
     * Set MaxConnections value
     * @param string $maxConnections
     * @return \SabreSoap\StructType\FlightTypePrefType
     */
    public function setMaxConnections($maxConnections = null)
    {
        $this->MaxConnections = $maxConnections;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @param string $preferLevel
     * @return \SabreSoap\StructType\FlightTypePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
}
