<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestLocationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Code and optional string to describe a location point.
 * @subpackage Structs
 */
class RequestLocationType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [A-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the context of the identifying code, such as IATA, ARC, or internal code, etc. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - default: IATA
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for RequestLocationType
     * @uses RequestLocationType::set_()
     * @uses RequestLocationType::setLocationCode()
     * @uses RequestLocationType::setCodeContext()
     * @param string $_
     * @param string $locationCode
     * @param string $codeContext
     */
    public function __construct($_ = null, $locationCode = null, $codeContext = 'IATA')
    {
        $this
            ->set_($_)
            ->setLocationCode($locationCode)
            ->setCodeContext($codeContext);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabreSoap\StructType\RequestLocationType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \SabreSoap\StructType\RequestLocationType
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \SabreSoap\StructType\RequestLocationType
     */
    public function setCodeContext($codeContext = 'IATA')
    {
        $this->CodeContext = $codeContext;
        return $this;
    }
}
