<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReissueInfoList StructType
 * Meta information extracted from the WSDL
 * - documentation: Reissue information
 * @subpackage Structs
 */
class ReissueInfoList extends AbstractStructBase
{
    /**
     * The ReissueInfo
     * Meta information extracted from the WSDL
     * - documentation: Reissue Info
     * - maxOccurs: unbounded
     * @var \SabreSoap\StructType\ReissueInfoType[]
     */
    public $ReissueInfo;
    /**
     * Constructor method for ReissueInfoList
     * @uses ReissueInfoList::setReissueInfo()
     * @param \SabreSoap\StructType\ReissueInfoType[] $reissueInfo
     */
    public function __construct(array $reissueInfo = array())
    {
        $this
            ->setReissueInfo($reissueInfo);
    }
    /**
     * Get ReissueInfo value
     * @return \SabreSoap\StructType\ReissueInfoType[]|null
     */
    public function getReissueInfo()
    {
        return $this->ReissueInfo;
    }
    /**
     * Set ReissueInfo value
     * @param \SabreSoap\StructType\ReissueInfoType[] $reissueInfo
     * @return \SabreSoap\StructType\ReissueInfoList
     */
    public function setReissueInfo(array $reissueInfo = array())
    {
        $this->ReissueInfo = $reissueInfo;
        return $this;
    }
    /**
     * Add item to ReissueInfo value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ReissueInfoType $item
     * @return \SabreSoap\StructType\ReissueInfoList
     */
    public function addToReissueInfo(\SabreSoap\StructType\ReissueInfoType $item)
    {
        $this->ReissueInfo[] = $item;
        return $this;
    }
}
