<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MileageDisplayType StructType
 * @subpackage Structs
 */
class MileageDisplayType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Mileage display type
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: Mileage display city | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $City;
    /**
     * The Surcharge
     * Meta information extracted from the WSDL
     * - documentation: Mileage surcharge percentage
     * - use: optional
     * @var int
     */
    public $Surcharge;
    /**
     * Constructor method for MileageDisplayType
     * @uses MileageDisplayType::setType()
     * @uses MileageDisplayType::setCity()
     * @uses MileageDisplayType::setSurcharge()
     * @param string $type
     * @param string $city
     * @param int $surcharge
     */
    public function __construct($type = null, $city = null, $surcharge = null)
    {
        $this
            ->setType($type)
            ->setCity($city)
            ->setSurcharge($surcharge);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\MileageDisplayType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SabreSoap\StructType\MileageDisplayType
     */
    public function setCity($city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get Surcharge value
     * @return int|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * Set Surcharge value
     * @param int $surcharge
     * @return \SabreSoap\StructType\MileageDisplayType
     */
    public function setSurcharge($surcharge = null)
    {
        $this->Surcharge = $surcharge;
        return $this;
    }
}
