<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the aircraft equipment type.
 * @subpackage Structs
 */
class EquipmentType extends AbstractStructBase
{
    /**
     * The AirEquipType
     * Meta information extracted from the WSDL
     * - documentation: This is the 3 character IATA code. | Used for Strings, length exactly 3
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - use: required
     * @var string
     */
    public $AirEquipType;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The ChangeofGauge
     * Meta information extracted from the WSDL
     * - documentation: Indicates there is an equipment change.
     * - default: false
     * - use: optional
     * @var bool
     */
    public $ChangeofGauge;
    /**
     * Constructor method for EquipmentType
     * @uses EquipmentType::setAirEquipType()
     * @uses EquipmentType::set_()
     * @uses EquipmentType::setChangeofGauge()
     * @param string $airEquipType
     * @param string $_
     * @param bool $changeofGauge
     */
    public function __construct($airEquipType = null, $_ = null, $changeofGauge = false)
    {
        $this
            ->setAirEquipType($airEquipType)
            ->set_($_)
            ->setChangeofGauge($changeofGauge);
    }
    /**
     * Get AirEquipType value
     * @return string
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \SabreSoap\StructType\EquipmentType
     */
    public function setAirEquipType($airEquipType = null)
    {
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabreSoap\StructType\EquipmentType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ChangeofGauge value
     * @return bool|null
     */
    public function getChangeofGauge()
    {
        return $this->ChangeofGauge;
    }
    /**
     * Set ChangeofGauge value
     * @param bool $changeofGauge
     * @return \SabreSoap\StructType\EquipmentType
     */
    public function setChangeofGauge($changeofGauge = false)
    {
        $this->ChangeofGauge = $changeofGauge;
        return $this;
    }
}
