<?php

namespace SabreSoap\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PollingStatusType EnumType
 * @subpackage Enumerations
 */
class PollingStatusType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'received'
     * @return string 'received'
     */
    const VALUE_RECEIVED = 'received';
    /**
     * Constant for value 'in progress'
     * @return string 'in progress'
     */
    const VALUE_IN_PROGRESS = 'in progress';
    /**
     * Constant for value 'complete'
     * @return string 'complete'
     */
    const VALUE_COMPLETE = 'complete';
    /**
     * Constant for value 'error'
     * @return string 'error'
     */
    const VALUE_ERROR = 'error';
    /**
     * Return allowed values
     * @uses self::VALUE_RECEIVED
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RECEIVED,
            self::VALUE_IN_PROGRESS,
            self::VALUE_COMPLETE,
            self::VALUE_ERROR,
        );
    }
}
